

; k2p4.asm ATmega8 8bit Rechts-Rotieren mit 16bit Verzgerungsschleife
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111        
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testschleife in einfhrendes Beispiel einbauen *****************
        in      r16,PIND        ; Eingabe Anfangsbitmuster vom Port D  *
loop:   out     PORTB,r16       ; Ausgabe Muster auf LEDs Port B       *
        bst     r16,0           ; B0 -> T-Bit                          *
        rol     r16             ; rotiere links                        *
        bld     r16,0           ; B0 <- T-Bit                          *
        ror     r16             ; rotiere rechts                       *
        ror     r16             ; rotiere rechts                       *
; Warteschleife 50 000 x 5 = 250 000 Takte = 250 ms bei 1 MHz          *
        ldi     XL,LOW(50000)   ; lade Low-Teil des Wartefaktors       *
        ldi     XH,HIGH(50000)  ; lade High-Teil des Wartefaktors      *
warte:  nop                     ; 1 Takt   verzgern                   *
        sbiw    XL,1            ; 2 Takte  16bit-Zhler - 1            *
        brne    warte           ; 2 Takte  bis Zhler Null             *
        rjmp    loop            ; Sprung zum Anfang der Ausgabeschleife*
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


