

; k2p11.asm ATmega8 Tabellensuchen Hexa-ASCII-Zeichen nach binr
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
loop:   in      akku,PIND       ; Eingabe Hexa-ASCII-Code PD0 bis PD7  *
        ldi     ZL,LOW(atab*2)  ; Z <- Tabellenanfangsadresse          *
        ldi     ZH,HIGH(atab*2) ;                                      *
suche:  lpm                     ; R0 <- Tabellenwert mit Hexa-Ziffer   *
        tst     r0              ; Endemarke Null erreicht ?            *
        breq    nicht           ; ja: nicht enthalten                  *
        cp      akku,r0         ; Eingabeziffer - Tabellenziffer       *
        breq    gleich          ; Tabelleneintrag gefunden             *
        adiw    ZL,2            ; nicht gefunden: nchster Eintrag     *
        rjmp    suche           ; und weiter suchen                    *
gleich: adiw    ZL,1            ; Ausgabewert auf nchster Adresse     *
        lpm                     ; R0 <- Ausgabe-Zahl                   *
        out     PORTB,r0        ; und ausgeben                         *
        rjmp    loop            ; neue Eingabe                         *
nicht:  ldi     akku,$ff        ; Fehlermarke 1111 1111                *
        out     PORTB,akku      ; ausgeben                             *
        rjmp    loop            ; neue Eingabe                         *
; Tabelle  Ziffer,Zahl .... Ziffer,Zahl,Endemarke                      *
atab: .DB  '0',0,'1',1,'2',2,'3',3,'4',4,'5',5,'6',6,'7',7,'8',8,'9',9;* 
      .DB  'A',10,'B',11,'C',12,'D',13,'E',14,'F',15;                  *       
      .DB  'a',10,'b',11,'c',12,'d',13,'e',14,'f',15,0,0; Endemarken   *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


