

// k6p11.c  ATmega8  Servomotor  Steuerung 
// Port B: Ausgabe Pulsdauer dual Low-Byte
// Port C: Ausgabe Pulsdauer dual High-Byte
// Port D: PD2=INT0  PD3=INT1    PD0 = Ausgang Steuersignal
// Konfiguration: interner Takt 1 MHz, externes RESET-Signal 
#include <avr/io.h>                    // Deklarationen
#include <avr/signal.h>                // Deklarationen fr Interrupt
#include <avr/interrupt.h>             // Deklarationen fr Interrupt
#define TAKT 1000000UL                 // Systemtakt intern ca. 1 MHz
volatile unsigned int puls, pause;     // Impulsdauer Pausendauer global
SIGNAL(SIG_INTERRUPT0)
{
 puls++;                               // Pulsdauer erhhen
 pause--;                              // Pause vermindern
}
SIGNAL(SIG_INTERRUPT1)
{
 puls--;                               //  Pulsdauer vermindern
 pause++;                              // Pause erhhen
}
void main(void)                        // Hauptfunktion
{ 
 volatile unsigned int i;                 // Zhler
 puls = 60; pause = 1100;              // Anfangswerte 
 DDRD = (1 << PD0);                    // PD0 ist Ausgang
 DDRB = 0xff;                          // Port B ist Ausgang        
 DDRC = 0xff;                          // Port C ist Ausgang 
 MCUCR |= (1 << ISC11) | (1 << ISC01); // Interrupts fallende Flanken
 GICR  |= (1 << INT1)  | (1 << INT0);  // Interrupts frei
 sei();                                // alle Interrupts frei
 while(1)                              // Arbeitsschleife 
 {
  cli();                               // Interrupts sperren
  PORTD |= (1 << PD0);                 // Ausgang PD0 High
  for (i = puls; i > 0; i--);          // High-Impuls ausgeben
  PORTD &= ~(1 << PD0);                // Ausgang PD0 Low
  sei();                               // Interrupts freigeben
  PORTB = (unsigned char) puls;       // Pulsdauer 
  PORTC = puls >> 8;                   // dual ausgeben   
  for (i = pause; i > 0; i--);         // Low-Zeit ausgeben
 } // Ende while                  
} // Ende main



