

// k4p3.c  ATmega8  Timer0 externer Takt Flankenzhler 
// Port B: Ausgabe            Zehner Einer
// Port C: Ausgabe Hunderter
// Port D: PD4 = T0 externer Takt durch entprellten Taster
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>          // Deklarationen
#define TAKT 1000000UL      // Controllertakt 1 MHz
#include "dual2bcd.c"       // dual -> BCD int (Hunderter Zehner Einer)
void main(void)           // Hauptfunktion
{
 DDRB = 0xff;             // Port B ist Ausgang
 DDRC = 0xff;             // Port C ist Ausgang
 TCCR0 |= 0x06;           // 110 Timer0 externer Takt fallende Flanke 
 while(1)                // laufenden Flankenzhler ausgeben
 {
  PORTC = dual2bcd(TCNT0) >> 8; // Port C Hunderter
  PORTB = dual2bcd(TCNT0);      // Port B: Zehner Einer 
 } // Ende while
} // Ende main
