

// k3p23.c  ATmega  Software-Interrupt
// Port B: Ausgabe Dual-Zhler 
// Port D: keine Eingabe: PD2 High belegt durch Software-Interrupt
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>        // Deklarationen
#include <avr/signal.h>    // Interrupt Deklarationen
#include <avr/interrupt.h> // Interrupt Deklarationen
#define TAKT 1000000UL     // Controllertakt 1 MHz
// ISR(INT0_vect)         // neue Bezeichnung
SIGNAL(SIG_INTERRUPT0)    // ISR Interrupt-Einsprung
{
 PORTB++;                 // Zhler PORT B + 1
}
void main(void)           // Hauptfunktion
{
 unsigned int zaehl = 0;  // 16bit Zhler 
 DDRB = 0xff;              // Port B ist Ausgang
 DDRD |= (1 << PD2);      // PD2 = INT0 ist Ausgang!
 PORTD |= (1 << PD2);     // PD2 High
 MCUCR |= (1 << ISC01);   // fallende Flanke
 GIMSK |= (1 << INT0);    // INT0 frei
 sei();                    // alle Interrupts frei
 while(1)                  // Arbeitsschleife
 {
  zaehl++;                 // 16bit Zhler + 1
  if (zaehl == 0) { PORTD &= ~(1 << PD2); PORTD |= (1 << PD2);} // Flanke
 } // Ende while
} // Ende main
