

// k3p22c.c  ATmega8  Interrupt INT0 beide Flanken und Takteingang Timer0
// Port B: Ausgabe Dualzhler
// Port D: Taste PD2 (INT0): Zhler + 1  PD4 (T0): Zhler - 1
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>         // Deklarationen
#include <avr/signal.h>     // Deklarationen fr Interrupt
#include <avr/interrupt.h>  // Deklarationen fr Interrupt
#define TAKT 1000000UL      // Controllertakt 1 MHz
// ISR (INT0_vect)          // neue Bezeichnung fr Interruptservice
SIGNAL(SIG_INTERRUPT0)      // Interruptservice fr INT0-Eingang
{
 PORTB++;                  // Zhler um 1 erhhen
}
// ISR (TIMER0_OVF_v       // neue Bezeichnung fr Interruptservice
SIGNAL(SIG_OVERFLOW0)      // Interruptservice fr Timer0 berlauf
{
 PORTB--;                  // Zhler um 1 vermindern
 TCNT0 = 0xff;             // Timer0 wieder mit max. Wert vorladen
}
void main(void)           // Hauptfunktion
{
 DDRB = 0xff;              // Port B ist Ausgang
 MCUCR |= (1 << ISC00);    // INT0 beide Flanken
 GIMSK |= (1 << INT0);     // INT0 frei
 TCCR0 |= 0x06;             // 110 Timer0 externer Takt fallende Flanke
 TIMSK |= (1 << TOIE0);    // Timer0 Interrupt frei
 TCNT0 = 0xff;              // Timer0 mit max. Wert vorladen
 sei();                    // alle Interrupts frei
 while(1)                  // 
 {
 } // Ende while
} // Ende main
