

; k4p2.asm Timer0 Sekundenzhler mit Interrupt
; Port B: Ausgabe            Zehner Einer
; Port C: Ausgabe Hunderter
; Port D: -
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern 
        .EQU    zael = 61       ; 1 MHz:256:64 = 61.03 gerundet 61
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    seku = r18      ; dualer Sekundenzhler mod 256
        .DEF    tic  = r19      ; Interruptzhler
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    OVF0addr        ; Timer0 berlauf Einsprung
        rjmp    timer           ; nach Interrupt-Service-Programm
        .ORG    $13             ; weitere Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
; Timer0 und Interrupt programmieren
        ldi     akku,0b011      ; Taktteiler : 64 
        out     TCCR0,akku      ; Steuerregister Timer0
        in      akku,TIMSK      ; akku <= Timer-Interrupt-Masken
        ori     akku,1 << TOIE0 ; TOIE0 = 1: Interrupt fr
        out     TIMSK,akku      ; Timer0 berlauf frei
        clr     seku            ; Sekundenzhler lschen
        out     PORTB,seku      ; Port B: 0 0 ausgeben
        out     PORTC,seku      ; Port C: 0 0 ausgeben
        ldi     tic,zael        ; Interruptzhler fr 1 sek laden
        sei                     ; I = 1: alle Interrupts frei
; Hauptprogramm schlft vor sich hin 
schlei: nop                     ; tu nix
        rjmp    schlei          ; 
;
; Einsprung Timer0 berlauf
timer:  push    r16             ; Register R16 retten
        in      r16,SREG        ; 
        push    r16             ; SREG retten
        push    r17             ; Register R17 retten
        dec     tic             ; Interruptzhler - 1
        brne    timer1          ; ungleich 0: weiter
        ldi     tic,zael        ;   gleich 0: Anfangswert
        inc     seku            ; dualer Sekundenzhler + 1
        mov     r16,seku        ; nach R16 fr Dezimalumwandlung
        rcall   dual2bcd        ; nach BCD R17:R16 umwandeln
        out     PORTB,r16       ; Zehner und Einer nach Port B
        out     PORTC,r17       ; Hunderter nach Port C
timer1: pop     r17             ; R17 zurckladen
        pop     r16             ; SREG zurck
        out     SREG,r16        ; laden
        pop     r16             ; R16 zurckladen
        reti                    ; Rcksprung nach Unterbrechung
; dual2bcd: Umwandlung R16 dual nach BCD dreistellig 
       .INCLUDE "dual2bcd.asm"  ; R16 dual -> R17 Hunderter R16 Zehner | Einer
       .EXIT                    ; Ende des Quelltextes


