

; k2p15.asm ATmega8 Prellungen aufzeichnen und auswerten
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
; Adresse und Zhler vorbereiten warte auf beliebige Taste PORT D      *
        ser     akku            ; Startmarke 1111 1111                 *
        out     PORTB,akku      ; ausgeben                             *
loop1:  ldi     XL,LOW(stab)    ; X <- Listenadresse                   *
        ldi     XH,HIGH(stab)   ;                                      *
        ldi     YL,LOW(1000)     ;Y <- Zhler mit Listenlnge          *
        ldi     YH,HIGH(1000)   ;                                      *
loop2:  in      akku,PIND       ; Akku <- Zustand PIND                 *
        cpi     akku,$ff        ; alles High ?                         *
        breq    loop2           ; ja: warte auf nderung               *
; Speicherschleife 7 Takte = 7 us Abtastrate bei 1 MHz                 *
loop3:  st      X+,akku         ; 2 Takte speichern                    *
        in      akku,PIND       ; 1 Takt  neuen Zustand laden          *
        sbiw    YL,1            ; 2 Takte 16bit Zhler dekrementieren  *
        brne    loop3           ; 2 Takte bei Sprung                   *
; Aufzeichnung auswerten Prellungen (nderungen) zhlen                *
        ldi     XL,LOW(stab)    ; X <- Listenadresse                   *
        ldi     XH,HIGH(stab)   ;                                      *
        ldi     YL,LOW(999)     ; Y <- Listenzhler Lnge-1            *
        ldi     YH,HIGH(999)    ; weil letzter ohne Nachfolger         *
        clr     akku            ; Zhler fr Prellungen lschen        *
loop4:  ld      r18,X+          ; R18 = laufender Wert                 *
        ld      r19,X           ; R19 = nchster Wert                  *
        cpse    r18,r19         ; berspringe wenn beide gleich        *
        inc     akku            ; bei ungleich: Prellung zhlen        *
        sbiw    YL,1            ; Listenzhler - 1                     *
        brne    loop4           ; bis alle Listenelemente durch        *
        out     PORTB,akku      ; Anzahl der Prellungen dual ausgeben  *
; warte bis Port D wieder High entprellen durch Warteschleife          *
loop5:  in      akku,PIND       ; Akku <- Zustand PIND                 *
        cpi     akku,$ff        ; alle High wieder High ?              *
        brne    loop5           ; nein: warten                         *
        clr     YL              ; Wartezhler lschen                  *
        clr     YH              ; 65536 * 4 Takte = 262 ms bei 1 MHz   *
loop6:  sbiw    YL,1            ; 2 Takte                              *
        brne    loop6           ; 2 Takte                              *
        rjmp    loop1           ; neuer Versuch                        *
; Datenbereich im SRAM                                                 *
        .DSEG                   ; Datensegment                         *
stab :  .BYTE   1000            ; 1000 Bytes fr Liste                 *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


