

; daa.asm Dezimalkorrektur R16 zweistellig nach ADD und ADC
daa:    push    r17              ; Hilfsregister retten
        in      r17,SREG         ; Status retten
        push    r17              ;
        clr     r17              ; EOR r17,r17 <= 0   C und H unverndert!
        brcc    daa1             ; Carry_alt nach Bit 0 von R17 sichern
        inc     r17              ; Calt == 1: R17.0 <= 1   Calt == 0: R17.0 <= 0
; Low-Ziffer korrigieren H-Bit==1 oder Zahl >  0000 1001: +6 gibt H = 1       
daa1:   brhs    daa2             ; H == 1: => immer korrigieren
        subi    r16,-6           ; ADDI akku,+6 (H negiert) Testkorrektur
        brhc    daa3             ; H == 0 (richtig H == 1 !) Korrektur o.K.
        subi    r16,6            ; H == 1 (richtig H == 0 !) Korr. zurck
        rjmp    daa3             ; nach High-Ziffer
daa2:   subi    r16,-6           ; H == 1: immer korrigieren
; High-Ziffer korrigieren Calt ==1 oder Zahl > 1001 0000: +$60 gibt H = 1
daa3:   subi    r16,-$60         ; ADDI R16,+$60 (Cneu negiert) immer Test
        brcc    daa4             ; C == 0 (richtig C == 1 !) => Korrektur o.K.
        sbrs    r17,0            ; berspringe wenn Calt==1:=> Korrektur o.K.
        rjmp    daa5             ; => Korrektur aufheben und Cneu <= 0 
daa4:   pop     r17              ; alten Status 
        out     SREG,r17         ; zurck
        sec                      ; Cneu <= 1 
        rjmp    daa6             ; fertig
daa5:   subi    r16,$60          ; Korrektur aufheben
        pop     r17              ; alten Status
        out     SREG,r17         ; zurck
        clc                      ; Cneu <= 0
daa6:   pop     r17              ; Hilfsregister zurck  
        ret                      ; Rcksprung 
