

// projekt1.c AT90S2343 Wrfelspiel Version 4.9.2006 mit Statistik erweitert
// Ausgabe: PB2 = SRCK  PB1 = RCK  PB0 = SERIN 
// Eingabe: PB4 = Taster  PB3 = reserviert
#include <avr/io.h>            // Deklarationen
#include <avr/signal.h>        // fr Timer0 Interrupt
#include <avr/interrupt.h>     // fr Timer0 Interrupt
#define TAKT 1000000UL         // interner Takt 1 MHz
#define WARTE 10UL*TAKT/4000UL // Entprellzeit ca. 10ms bei 4 Takten (angenommen)
#define SERIN 0                // PB0 = Anschluss serielle Eingabe
#define RCK 1                  // PB1 = Anschluss bernahmetakt
#define SRCK 2                 // PB2 = Anschluss Schiebetakt
#define GRUEN 4                // LED Grn Bit 4 gewonnen
#define ROT 5                  // LED Rot Bit 5 verloren
#define GELB 6                 // LED Gelb Bit 6 wrfeln
#define TASTE PINB4            // Eingabetaste
#define NSPIEL 10              // Endwert Spielezhler
// globale Variablen fr die Ausgabe mit Anfangswerten
unsigned char stelle[4] = {0,0,0,0}, leds = 0xf0, anoden = 0x08, pos = 0;
unsigned char wuerfel1, wuerfel2, summe, vorgabe;                 // Variablen
unsigned char marke = 0, spiele = 0, verlo = 0, gewon = 0;        // Statistik
unsigned char augen1[6]={0,0,0,0,0,0}, augen2[6]={0,0,0,0,0,0}; // Statistik
//
SIGNAL (SIG_OVERFLOW0)            // bei Timer0 berlauf serielle Multiplexausgabe
{
 unsigned char schieber,i;      // 8bit Schieberegister und Laufindex
 schieber = ~(stelle[pos++]);    // Komplement Katoden 
 cbi(PORTB,RCK);                 // Speichertakt Low
 for (i = 1; i<=8; i++)         // Ausgabeschleife Katoden
 {
  cbi(PORTB,SRCK);               // Schiebetakt Low
  if(schieber & 0x80) sbi(PORTB,SERIN); else cbi(PORTB,SERIN); // Datenbit
  sbi(PORTB,SRCK);               // Schiebetakt High steigende Flanke
  schieber <<= 1;                // Ausgabemuster nach links schieben
 } // Ende for
 schieber = ~(leds | anoden);    // Komplement LEDs und Anoden
 for (i = 1; i<=8; i++)         // Ausgabeschleife LEDs und Anoden
 {
  cbi(PORTB,SRCK);               // Schiebetakt Low
  if(schieber & 0x80) sbi(PORTB,SERIN); else cbi(PORTB,SERIN); // Datenbit
  sbi(PORTB,SRCK);               // Schiebetakt High steigende Flanke
  schieber <<= 1;                // Ausgabemuster nach links schieben
 } // Ende for 
 sbi(PORTB,RCK);                 // Speichertakt High steigende Flanke
 cbi(PORTB,SRCK);                // Schiebetakt Low 
 cbi(PORTB,RCK);                 // Speichertakt Low
 anoden >>= 1; if (anoden == 0) {anoden = 0x08; pos = 0;} // nchste Anzeige vorbereiten
} // Ende SIGNAL
//
unsigned char codieren (unsigned char wert)  // Zahl nach Anzeigecode umwandeln
{
 unsigned char code[14]={0x3f,0x06,0x5b,0x4f,0x66,0x6d,0x7d,0x07,0x7f,0x6f,0x3f,0x06,0x5b,0};
 return code[wert];
}
//
unsigned char rollen(void)     // liefert Summe legt Augen nach global wuerfel1 wuerfel2
{
 unsigned int i;                // Laufindex fr Entprellschleife
 wuerfel1 = 1;                   // Wrfel Anfangswert Konstrolle Taste > 1 sek
 while(bit_is_set(PINB,TASTE)) { wuerfel1++; if (wuerfel1 == 7) wuerfel1 = 1; }     
 for (i=1; i<=WARTE; i++);      // fallende Flanke entprellen
 wuerfel2 = 1;
 i = 0; marke = 0;                // Marke fr Taste > 1 sek gedrckt lschen
 while(bit_is_clear(PINB,TASTE)) // warte auf steigende Flanke 
  { wuerfel2++; if (wuerfel2 == 7) wuerfel2 = 1; i++; if (i > 65000) marke = 1;}
 for (i=1; i<=WARTE; i++);      // steigende Flanke entprellen 
 return wuerfel1 + wuerfel2;     // Rckgabe Summe
} // Ende rollen
//
void ausgabe1(void)                        // Ausgabe beide Wrfel links
{
 stelle[3] = codieren(wuerfel1) | 0x80;    // Wrfel #1 anzeigen mit Punkt
 stelle[2] = codieren(wuerfel2);           // Wrfel #2 anzeigen 
} // Ende ausgabe1
//
void ausgabe2(unsigned char wert)        // Ausgabe Zahl 0 .. 99 rechts
{
 unsigned char zehner = 0;
 while (wert > 9) { zehner++; wert -=10; }  // Einer- und Zehnerstelle
 stelle[0] = codieren(wert);                 // Einer ausgeben
 if (zehner == 0) stelle[1] = codieren(13); else stelle[1] = codieren(zehner);
} // Ende ausgabe2
// 
void statistik(void)                   // Spielstatistik 
{                                       // GEwonnen VErloren Augen der Wrfel
 unsigned char i;
 for(i = 0; i < 4; i++) stelle[i] = 0x40; leds = 0;  // Anzeige - LEDs aus
 rollen();                              // warte auf Taste 
 leds = (1 << GRUEN) | (1 << ROT);     // Rot und Grn: Anzeige SP 
 stelle[3] = 0x6d;                      // 0110 1101 Code S
 stelle[2] = 0x73;                      // 0111 0011 Code P 
 ausgabe2(spiele);                      // Anzahl der Spiele ausgeben
 rollen();                              // warte auf Taste
 leds = (1 << GRUEN);                  // Grn
 stelle[3] = 0x7d; stelle[2] = 0x79;   // 0111 1101 01111001 Code G E
 ausgabe2(gewon);                       // Ausgabe zweistellig gewonnen
 rollen();                              // warte auf Taste
 leds = (1 << ROT);                    // ROT
 stelle[3] = 0x3e; stelle[2] = 0x79;   // 0011 1110 01111001 Code V E
 ausgabe2(verlo);                      // Ausgabe zweistellig verloren
 rollen();                             // warte auf Taste
 leds = 0; stelle[2] = 0x63;           // LEDs aus Code Karo oben 
 for(i=0; i< 6; i++)                  // Augen Wrfel 1
  { stelle[3] = codieren(i+1); ausgabe2(augen1[i]); rollen(); }
 stelle[2] = 0x5c;                    // LEDs aus Code Karo unten
 for(i=0; i< 6; i++)                 // Augen Wrfel 2
  { stelle[3] = codieren(i+1); ausgabe2(augen2[i]); rollen(); }
 spiele = 0; verlo = 0; gewon = 0;    // Zhler wieder lschen
 for(i=0; i<6; i++) {augen1[i] = 0; augen2[i] = 0; } 
}
//
void main (void)            // Hauptfunktion
{
 unsigned char i, lauf;
 DDRB = 0x07;               // 111 PB2 PB1 PB0 sind Ausgnge
 TCCR0 = 0x2;               // 010 Timer0 Teiler 8: 1 MHz : 8 = 125 kHz : 256 = 488 Hz = 2 ms
 TIMSK |= (1 << TOIE0);    // Timer0 Interrupt frei
 sei();                     // alle Interrupts frei 
 while(1)                  // Spielschleife
 {
  for(i = 0; i < 4; i++) stelle[i] = 0; leds = (1 << GELB); // Grundzustand 
  summe = rollen();        // Wrfeln
  if (marke)               // Taste lnger als 1 sek gedrckt
  {
  statistik();             // Spielestatistik ausgeben
  for(i = 0; i < 4; i++) stelle[i] = 0; leds = (1 << GELB); // Grundzustand 
  summe = rollen();       // erneut Wrfeln  
  } //Ende if
  ausgabe1(); ausgabe2(summe);    // Augen und Summe ausgeben
  augen1[wuerfel1-1]++; augen2[wuerfel2-1]++;                // Statistik Augen zhlen
  if (summe == 7 || summe == 11) {leds = (1 << GRUEN); gewon++; }
   else if(summe == 2 || summe == 3 || summe == 12) {leds = (1 << ROT); verlo++;}
    else                                              // Zustand Schleife
    {
     vorgabe = summe;
     stelle[2] |= 0x80; stelle[0] |= 0x80;           // Marken fr Zustand Schleife
     lauf = 1;
     while(lauf)                                     // Zustand Schleife
     {
      summe = rollen(); ausgabe1();                  // wrfeln und ausgeben
      augen1[wuerfel1-1]++; augen2[wuerfel2-1]++;   // Statistik
      stelle[2] |= 0x80;                             // Marke DP 
      if (summe == vorgabe) { leds = (1 << GRUEN); gewon++; lauf = 0; }
      if (summe == 7) { leds = (1 << ROT); ausgabe2(7); verlo++; lauf = 0; }
     } // Ende while lauf
    } // ende else schleife
   rollen();                                       // warte auf Taste fr Neustart
   spiele++; if (spiele >= NSPIEL) statistik();   // Statistik nach NSPIEL Spielen
 } // Ende while immer
} // Ende main
