

// pctast.c 
// Port B: PC-Tastatur: PB5: Takt  PB3: Daten
// Hilfsfunktion tastet Daten- und Taktleitung ab liefert Scancode
unsigned char pcscan(void)
{
 unsigned char i, daten = 0;
 while ( (PCPORT & (1 << PCTAKT)));        // warte auf fallende Flanke Startbit
 while ( !(PCPORT & (1 << PCTAKT)));       // warte solange Startbit Low
 for (i = 1; i <= 8; i++)                  // 8 Datenbits abtasten
 {      
  while ( (PCPORT & (1 << PCTAKT)));       // warte solange Takt High
  while ( !(PCPORT & (1 << PCTAKT)));      // warte solange Takt Low
  daten >>= 1;                             // Byte logisch rechts Bit_7 = 0
  if (PCPORT & (1 << PCDAT)) daten |= 0x80; // Bit_7 = 1
 }
 for (i = 1; i <= 2; i++)                  // Parittsbit und Stoppbit abwarten
 {
  while ( (PCPORT & (1 << PCTAKT)));       // warte solange Takt High
  while ( !(PCPORT & (1 << PCTAKT)));      // warte solange Takt Low
 }
 return daten;                             // Scancode zurck
} // Ende pcscan
// Funktion liefert Scan-Code und ASCII-Code oder 0x00 an main
void pctast (unsigned char *ascii, unsigned char *scan)
{
 // ASCII-Tabelle statisch angelegt
 const static unsigned char pctab [] = \
 { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5e,0x0, \ 
   0x0, 0x0, 0x0, 0x0, 0x0, 'Q', '1', 0x0, 0x0, 0x0, 'Y', 'S', 'A', 'W', '2', 0x0, \
   0x0, 'C', 'X', 'D', 'E', '4', '3', 0x0, 'F', ' ', 'V', 0x0, 'T', 'R', '5', 0x0, \
   0x0, 'N', 'B', 'H', 'G', 'Z', '6', 0x0, 0x0, 0x0, 'M', 'J', 'U', '7', '8', 0x0, \
   0x0, ',', 'K', 'I', 'O', '0', '9', 0x0, 0x0, '.', '-', 'L', '', 'P', '', 0x0, \
   0x0, 0x0, '', 0x0, '', 0x27,0x0, 0x0, 0x0, 0x0, 0x0, '+', 0x0, '#', 0x0, 0x0, \
   0x0, '<', 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, \ 
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, \
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5e,0x0, \
   0x0, 0x0, 0x0, 0x0, 0x0, 'q', '1', 0x0, 0x0, 0x0, 'y', 's', 'a', 'w', 0x23,0x0, \
   0x0, 'c', 'x', 'd', 'e', '$', '', 0x0, 'f', ' ', 'v', 0x0, 't', 'r', '&', 0x0, \
   0x0, 'n', 'b', 'h', 'g', 'z', '&', 0x0, 0x0, 0x0, 'm', 'j', 'u', '7', '(', 0x0, \
   0x0, ',', 'k', 'i', 'o', '=', ')', 0x0, 0x0, ':', '-', 'l', '', 'p', '?', 0x0, \
   0x0, 0x0, '', 0x0, '', 0x2 ,0x0, 0x0, 0x0, 0x0, 0x0, '*', 0x0,0x27, 0x0, 0x0, \
   0x0, '>', 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, \
   0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }; 
  unsigned char code;
  weiter:                        // unfeines Sprungziel
  do                             // bis Break-Code
  {
   code = pcscan();              // liefert Scan-Code
   if (code == 0x12) zustand = 0x80;  // Shift-links
  }
  while (code != 0xF0);          // warte auf Break-Code
  code = pcscan();               // Make-Folgecode 
  if (code == 0x12) { zustand = 0x00; goto weiter; } // unfeiner Sprung 
  *scan = code;                  // Rckgabe Scan-Code
  code |= zustand;               // Zustandsbit gross/klein einbauen
  *ascii = pctab[code];          // Rckgabe ASCII-Code oder 0x00
 } // Ende pctast
 