

// k6p7.c  ATmega8  Temperatursensor AMT160-30 Tastzeiten ausgeben
// Port B: B7-B0: Ausgang High-Zeit
// Port C: C5-C0: Eingang PC0 = Fhler
// Port D: D7-D0: Ausgang Periodenzeit 
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>    // Deklarationen
#define fuehl PINC     // Fhlerport
#define pin  PC0       // Fhleranschluss
void main(void)       // Hauptfunktion
{
 long int summhi, summlo;     // Zhler High-Zeit und Low-Zeit
 unsigned int i;              // Zhler fr Mittelwertbildung
 unsigned char werthi, wertlo;  // fr 8bit Ausgabe
 DDRB = 0xff;                  // 1111 1111 Port B ist Ausgang
 DDRD = 0xDf;                  // 1111 1111 Port D ist Ausgang
 while(1)                     // Arbeitsschleife
 {
  summhi = summlo = 0;                          // Zhler lschen
  for (i = 1; i <= 256; i++)                   // summiert 256 Messwerte
  {
   while ( !(fuehl & (1 << pin)));             // warte solange Low
   while (  (fuehl & (1 << pin)));             // warte solange High
   while ( !(fuehl & (1 << pin))) summlo++;    // zhle solange Low
   while (  (fuehl & (1 << pin))) summhi++;    // Zhle solange High
  } // Ende for
  werthi = summhi >> 8;                          // Mittel = Summe / 256
  wertlo = werthi + (summlo >> 8);               // Mittel = Summe / 256
  PORTB = ((werthi / 10) << 4) | (werthi % 10); // High-Zeit dual nach BCD
  PORTD = ((wertlo / 10) << 4) | (wertlo % 10); // Periodenzeit dual nach BCD
 } // Ende while
} // Ende main



