


// k6p3.c  LED-Matrix mit dem Tiny2313
// Port B: B0..B3 Ausgnge Spaltenauswahl B4: Eingang Rcksetzen
// Port D: D0..D6 Ausgnge Spaltencode
#include <avr/io.h>                      // Deklarationen
#include <avr/signal.h>                  // fr Interrupt
#include <avr/interrupt.h>               // fr Interrupt
unsigned char sek = 0, spalte = 0, zaehl = 0;    // globale Zhler 
unsigned char aus[15];                // globale Variable Ausgabebereich
unsigned char code[56] = {0x3e,0x41,0x41,0x3e,0, 0x00,0x10,0x20,0x7f,0, \
                          0x22,0x45,0x49,0x31,0, 0x2a,0x49,0x49,0x36,0, \
                          0x78,0x08,0x1f,0x08,0, 0x71,0x49,0x4a,0x0c,0, \
                          0x3e,0x49,0x49,0x06,0, 0x43,0x44,0x48,0x30,0, \
                          0x3e,0x49,0x49,0x3e,0, 0x32,0x49,0x49,0x3e,0, \
                          0,0,0,0,0,0 };  // Ziffern 0..9 und Leerzeichen
void ausgabe(unsigned char x)     // Zahl umcodieren und nach Ausgabespeicher
{
 unsigned char i, j=0, z;         // lokale Zhler
 z = x/100; if (z == 0) z = 10;    // Hunderter-Null unterdrcken
 for (i=0; i<5; i++) aus[j++] = code[z*5 + i];
 x = x % 100;                      // Divisionsrest
 if ( ( (x/10) == 0) && (z == 10)) z = 10; else z = x/10; // Zehner-Null
 for (i=0; i<5; i++) aus[j++] = code[z*5 + i];
 for (i=0; i<5; i++) aus[j++] = code[(x%10)*5 + i]; 
}
SIGNAL(SIG_TIMER1_OVF)          // Einsprung Timer1 berlauf MUX Spalte
{
 PORTD = aus[spalte];           // Spaltenbyte
 PORTB = spalte++;              // Spalte ansteuern
 if (spalte == 15) spalte = 0; // Spalten 0..14
 TCNT1 = 65536ul - 3686ul;     // Wartezeit fr 1 kHz Muxfrequenz
}
SIGNAL(SIG_TIMER0_OVF)          // Einsprung Timer0 berlauf 
{
 zaehl++;                       // Interruptzhler
 if (zaehl == 225) { zaehl = 0; sek++; ausgabe(sek); }  // Sekunden
}

void main(void)              // Hauptfunktion
{
 DDRB=0x0f;                   // 0000 1111 B0..B3 Ausgnge
 DDRD=0x7f;                   // 0111 1111 D0..D6 Ausgnge
 ausgabe(sek);                // Anfangswert nach Ausgabespeicher
 TCCR0B = 0x03;               // Timer0 3.6864 MHz : 64 : 256 = 225 Durchlufe fr 1 sek
 TIMSK |= (1<<TOIE0);        // Timer0 Interrupt frei
 TCCR1B = 0x01;               // Timer1 MUX 3.686400 : 1 : 3686 = 1 kHz 
 TCNT1 = 65536ul - 3686ul;    // Wartezeit fr 1 kHz Muxfrequenz
 TIMSK |= (1<<TOIE1);        // Timer1 Interrupt frei
 sei();                      // alle Interrupts frei
 while(1)                    // Arbeitsschleife
 {
  while(PINB & (1 << PB4));    // warte auf Tastenbettigung
  sek = 0; ausgabe(sek);        // Sekundenzhler lschen
  while(!(PINB & (1 <<PB4)));  // warte auf Lsen der Taste  
 } // Ende while
} // Ende main
 