
// k4p8.c  ATmega8  Timer1  einfacher PWM-Betrieb
// Port B: Ausgang PB1 OC1A Signalausgabe PWM 
// Port C: Eingabe PC1=Bit_9 PC0=Bit_8
// Port D: Eingabe                     PD7=Bit_7   PD0=Bit_0
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>    // Deklarationen
#define TAKT 1000000UL // Systemtakt intern ca. 1 MHz
void main(void)         // Hauptfunktion
{ 
 DDRB = (1 << PB1);    // PB1 OC1A ist Ausgang
 OSCCAL = 0xC2;        // RC Oszillator kalibrieren
 TCCR1A = (1 << COM1A1) | (1 << WGM11) | (1 << WGM10); // 10bit 
 TCCR1B = 0x01;        // Taktteiler :1
 while(1)              // Arbeitsschleife Eingabe High-Zeit
 {
  OCR1AH = PINC;       // Port C Compare-High PC1=Bit_9 PC0=Bit_8
  OCR1AL = PINC;       // Port D Compare-Low  PD7=Bit_7   PD0=Bit_0
 } // Ende while                  
} // Ende main

 
  

