

// k4p24.c ATmega16 AD-Wandler Differenzmessung
// Systemtakt 3.6864 MHz : 32 = 115.2 kHz Wandlungstakt
// Port B: Ausgabe BCD Hunderter 
// Port D: Ausgabe BCD Zehner und Einer
// Port A: Eingabe Potentiometer +ADC2 nach -ADC1 
#include <avr/io.h>    // Deklarationen
void main(void)       // Hauptfunktion
{
 unsigned char x;     // Hilfsvariable
 DDRB = 0xff;          // Port B ist Ausgang
 DDRD = 0xff;          // Port D ist Ausgang
 ADMUX = (1 << ADLAR) | (1  << MUX4) | (1 << MUX1);
 ADCSR = (1 << ADEN) | (1 << ADSC) | (1 << ADPS2) | (1 << ADPS0);
 while(1)             // Arbeitsschleife
 {
  loop_until_bit_is_clear(ADCSR,ADSC); // warte auf Ende der Wandlung 
  x = ADCL;          // Low Bits abholen
  x = ADCH;          // High Byte abholen
  PORTB = x / 100;   // Hunderter 
  PORTD = ( ( (x % 100) / 10) << 4) | ((x % 100) % 10); // Zehner Einer
  sbi(ADCSR,ADSC);   // Wandler neu starten
 } // Ende while
} // Ende main



