

// k3p12.c  ATmega8  Sinustabelle aufbauen und ausgeben
// Port B: Ausgabe des Sinus auf D/A-Wandler 
// Port D: - 
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>                // Deklarationen
#include <math.h>                  // M_PI und sin
#define TAKT 1000000UL             // Controllertakt 1 MHz
void main(void)                  // Hauptfunktion
{
 unsigned char sinus[360];       // Sinustabelle von 0 bis 359 Grad
 unsigned int i;                 // Laufvariable
 DDRB = 0xff;                     // Port B ist Ausgang
 for (i=0; i<360; i++) sinus[i] = sin(i*M_PI/180)*127 + 127; 
 while(1)                        // Arbeitsschleife
 {
  for (i=0; i<360; i++) PORTB = sinus[i]; // Ausgabe D/A-Wandler
 } // Ende while
} // Ende main
