

; test25.asm Test 90S8515 
; k2p1.asm Bild 2-2 Dualzhler als Taktteiler 
; Port B: Ausgabe LED  PB0 = Takt / 10   PB7 = Takt / 1280
; Port D: -
        .INCLUDE "m8515def.inc"  ; Deklarationen 
        .INCLUDE "Mkonsole.h"     ; Makros Minituart,Mputch,Mputkon,Mgetch,Mgetche,Mkbhit
        .EQU    TAKT = 8000000    ; Systemtakt 8 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    startx           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapelzeiger
        out     SPL,akku        ; anlegen
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ;
        ser     akku            ; akku <- $ff
        out     DDRB,akku       ; Port B ist Ausgang
        clr     akku            ; Zhler lschen
; Taktteiler: 5 Takte Low / 5 Takte High gibt Takt / 10
loop:   out     PORTB,akku      ; 1 Takt:  Zhler ausgeben
        inc     akku            ; 1 Takt:  Zhler erhhen
        nop                     ; 1 Takt:  verlngert Schleife
        rjmp    loop            ; 2 Takte: Schleife
;
; k4p14.asm Bild 4-48  USART-Test mit Konsol-Makros
; Port B: -
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
;        .INCLUDE "m16def.inc"     ; Deklarationen fr ATmega16
 
;        .DEF    akku = r16        ; Arbeitsregister
;        .CSEG                     ; Programm-Flash
;         rjmp   start             ; Reset-Einsprung
;        .ORG    $2A               ; Interrupteinsprnge bergehen
startx:   ldi    akku,LOW(RAMEND)  ; Stapelzeiger laden
         out    SPL,akku          ;
         ldi    akku,HIGH(RAMEND) ;
         out    SPH,akku          ;
         Minituart 9600           ; USART initialisieren 9600 Baud bei TAKT
neu:     Mputkon   '>'            ; > ausgeben
schlei:  Mgetch  akku             ; Zeichen ohne Echo empfangen
         cpi     akku,$1b         ; Steuerzeichen Escape ?
         breq    loopx             ; nein: kein Echo
         Mputch  akku             ;   ja: Echo
         rjmp    schlei           ; und neue Eingabe
; Ausgabeschleife mit * bis Abbruch mit beliebiger Taste
loopx:    Mputkon $55              ; $55 = 0b01010101 = U ausgeben
         Mkbhit  akku             ; Empfnger testen
         tst     akku             ; Akku <- Null Zeichen da ?
         breq    loopx             ; Null: kein Zeichen da
         rjmp    neu              ; ungleich Null: Abbruchzeichen nicht ausgeben


       .EXIT                    ; Ende des Quelltextes  

