

; test24.asm Anwendungsbeispiel Stopp-Uhr 90S2313
; Port B: Ausgabe BCD Hunderter und Zehner 
; Port D: PD0..PD3 BCD Einer  PD6 msek/sek  PD5:Start/Stopp  PD4: frei
        .INCLUDE "2313def.inc"  ; Deklarationen fr 90S2313
        .EQU    takt = 30720000 ; Systemtakt 3.072 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    zaehl = r20     ; R20 = Interruptzhler
        .DEF    fehl  = r21     ; R21 = Fehlermarke
        .DEF    teil  = r22     ; R22 = Taktteiler fr Timerstart
        .CSEG                   ; Programmsegment
        rjmp    start           ; Reset-Einsprung
        .ORG    $6              ; Einsprung Timer0 Overflow
        rjmp    tictac          ; jede ms berlauf
        .ORG    $10             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen (max. 128 Bytes)
        out     SPL,akku        ;
        ldi     akku,$ff        ; Port B 
        out     DDRB,akku       ; ist Ausgang
        ldi     akku,$0f        ; 0000 1111 
        out     DDRD,akku       ; D3..D0 sind Ausgnge
        in      akku,TIMSK      ; altes Timer Interruptmasken
        ori     akku,1 << TOIE0 ; Timer0-Overflow-Interrupt
        out     TIMSK,akku      ; frei
; alle Zhler lschen
        ldi     zaehl,12        ; 3072000: 256 = 12000:12 = 1000 Hz = 1 ms
        clr     fehl            ; R21 = Fehlermarke lschen
        clr     XL              ; X = ms-Zhler lschen
        clr     XH              ;
        clr     YL              ; Y = sek-Zhler lschen
        clr     YH              ; 
        out     TCNT0,YH        ; Timer0 lschen
        ldi     teil,1 << CS00  ; R22 <- Taktteiler 1
; warte auf PD5 fallende Flanke der ersten Messung
haupt:  sbic    PIND,PD5        ; berspringe bei Low = gedrckt
        rjmp    haupt           ; warte solange High
haupt1: out     TCCR0,teil      ; Timer start
        sei                     ; Interrupt frei
        ldi     akku,$ff        ; 1111 1111 Anzeigen dunkel
        out     PORTD,akku      ; 
        out     PORTB,akku      ; 
        clr     teil            ; R22 <- Timer stopp vorbereiten
; warte auf steigende Flanke PD5 = Stopp-Flanke
haupt2: sbis    PIND,PD5        ; berspringe bei High = gelst
        rjmp    haupt2          ; warte solange Low
        out     TCCR0,teil      ; Timer stopp
        cli                     ; Interrrupt gesperrt
        ldi     zaehl,12        ; R20 = Interruptzhler
        ldi     teil,1 << CS00  ; R22 <- Takteiler 1 fr Start
        clr     akku            ; akku <- 0
        out     TCNT0,akku      ; Timer0 lschen
; Messung auswerten
        tst     fehl            ; berlauf-Fehlermarke testen
        breq    haupt3          ; kein Fehler
        ldi     akku,$CC        ; Fehler: Marke U U U
        out     PORTB,akku      ; ausgeben
        out     PORTD,akku      ;
        clr     XL              ; Zhler lschen
        clr     XH              ;
        clr     YL              ;
        clr     YH              ;
        clr     fehl            ;
        rjmp    haupt           ; warte auf fallende Flanke
haupt3: mov     r16,XL          ; R17:R16 <- msek dual
        mov     r17,XH          ;
        clr     XL              ;
        clr     XH
        rcall   dual3bcd        ; R17:R16 <- msek BCD
        mov     r18,r16         ; R18 <- msek Einer
        mov     r19,r17         ; R19 <- msek Hunderter | Zehner
        mov     r16,YL          ; R17:R16 <- sek dual
        mov     r17,YH          ; 
        clr     YL              ;
        clr     YH              ; 
        rcall   dual3bcd        ; R17 <- sek Hunderter | Zehner R16 <- sek Einer
; PD6 Auswahl Sekunden / Millisekunden 
haupt4: sbis    PIND,PD6        ; berspringe bei High: sek
        rjmp    haupt5          ; Low: msek
        out     PORTB,r17       ; High: Sekunden Hunderter Zehner
        out     PORTD,r16       ;                Einer
        rjmp    haupt6          ;
haupt5: out     PORTB,r19       ;  Low: Millisekunden Hunderter Zehner
        out     PORTD,r18       ;                     Einer
; warte auf neue fallende Startflanke PD5
haupt6: sbic    PIND,PD5        ; 
        rjmp    haupt4          ; Taste High: neue Auswahl
        rjmp    haupt1          ; Taste Low:  neue Messung
;
; Timer0 berlauf-Interrupt 12mal pro Millisekunde 
tictac: push    akku            ; Register retten
        in      akku,SREG       ; Status
        push    akku            ;
        dec     zaehl           ; Interruptzhler - 1
        brne    tictac1         ; noch nicht Null
; 1 Millisekunde vergangen X=ms  Y=sek
        ldi     zaehl,12        ; Null: Interruptzhler <- Anfangswert
        adiw    XL,1            ; ms erhhen
        ldi     akku,HIGH(1000) ; schon 1 sek erreicht ?
        cpi     XL,LOW(1000)    ; Low-Teil
        cpc     XH,akku         ; High-Teil und Carry
        brlo    tictac1         ;  < 1000: weiter
        clr     XL              ; >= 1000: ms lschen
        clr     XH              ;
        adiw    YL,1            ; sek erhhen
        cpi     YL,LOW(1000)    ; berlauf <= 1000 ?
        cpc     YH,akku         ; High-Teil und Carry
        brlo    tictac1         ; < 1000
        ldi     fehl,1          ; Fehlermarke setzen
tictac1:pop     akku            ; Register zurck
        out     SREG,akku       ;
        pop     akku            ;
        reti                    ;
; internes Unterprogramm dual -> BCD dreistellig
; R17:R16 0..999 dual -> R17<=Hunderter | Zehner  R16<=0000 | Einer
dual3bcd:push   r18             ; Register retten
        push    r19             ;
        clr     r18             ; R18 = Stellen-Zhler lschen
        ldi     r19,HIGH(100)   ; R19 = Hilfsregister High-Teil
dual3bcd1:cpi   r16,LOW(100)    ; Hunderterprobe
        cpc     r17,r19         ; 
        brlo    dual3bcd2       ;  < 100: fertig
        subi    r16,LOW(100)    ; >= 100: abziehen
        sbci    r17,HIGH(100)   ; 
        inc     r18             ; R18 = Hunderter erhhen
        rjmp    dual3bcd1       ;
dual3bcd2:swap  r18             ; R18 = Hunderter | 0000
dual3bcd3:cpi   r16,10          ; Zehnerprobe
        brlo    dual3bcd4       ;  < 10: fertig
        subi    r16,10          ; >= 10: abziehen
        inc     r18             ; R18 = Zehner erhhen
        rjmp    dual3bcd3       ; R16 <= 0000      | Einer
dual3bcd4:mov   r17,r18         ; R17 <= Hunderter | Zehner
        pop     r19             ; Register zurck
        pop     r18             ;
        ret                     ; 
        .EXIT                   ; Ende des Quelltextes
  