

; test22.asm Test BCD  <--> dual  8/16 bit
; Port B:  Ausgabe  0  0   0  0  | Zehntausender
; Port C:  Ausgabe Tausender     | Hunderter
; Port D   Ausgabe Zehner        | Einer
        .INCLUDE "m16def.inc"    ; Deklarationen fr ATmega16
        .INCLUDE "Mmul16.asm"
        .DEF    akku = r16       ; Arbeitsregister
        .CSEG                    ; Programm-Flash
         rjmp   start            ; Reset-Einsprung
        .ORG    $2A              ; Interrupteinsprnge bergehen
start:   ldi    akku,LOW(RAMEND) ; Stapelzeiger laden
         out    SPL,akku         ;
         ldi    akku,HIGH(RAMEND);
         out    SPH,akku         ;
         ldi    akku,$ff         ;
         out    DDRB,akku        ; Port B ist Ausgang
         out    DDRC,akku        ; Port C ist Ausgang
         out    DDRD,akku        ; Port D ist Ausgang
; 8bit Umwandlung testen
         clr    XL               ; Zhler lschen
loop:    mov    r16,XL           ; R16 <- dual
         rcall  dual2bcd         ; R17 Hunderter R16 Zehner | Einer
         out    PORTC,r17        ; PORTC <- Hunderter
         out    PORTD,r16        ; PORTD <- Zehner | Einer
         rcall  bcd2dual         ; R16 <- dual
         brcs   error            ; berlauf
         cp     r16,XL           ; vergleichen
         brne   error            ;
         adiw   XL,1             ; Zhler erhhen
         cpi    XH,$ff           ; 
         breq   loop1            ; XH = $ff: nach 16bit 
         rjmp   loop             ;
; 16bit Umwandlung testen
loop1:   clr    XL               ; Zhler lschen
         clr    XH               ;
loop2:   mov    r16,XL           ; R17:R16 <- Zhler
         mov    r17,XH           ;
         rcall  dual4bcd         ; BCD <- dual
         out    PORTB,r18        ; PORTB <- Zehntausender
         out    PORTC,r17        ; PORTC <- Tausender | Hunderter
         out    PORTD,r16        ; PORTD <- Zehner    | Einer
         rcall  bcd4dual         ; dual <- BCD
         brcs   error            ; berlauf
         cp     r16,XL           ; vergleichen
         brne   error            ;
         cp     r17,XH           ;
         brne   error            ;
         adiw   XL,1             ; Zhler erhhen
         breq   loop3            ; X = 0: -> berlaufkontrolle
         rjmp   loop2            ; Endlosschleife
; berlaufkontrolle PORTB: Zt  PORTC: T H  PORTD: Ze E 
loop3:   clr    akku             ;
         out    DDRD,akku        ; PORTD ist Eingang
         out    DDRC,akku        ; PORTC ist Eingang
         ldi    akku,$f0         ;
         out    DDRB,akku        ; PB7-PB4 Ausgang PB3-PB0 Eingang
loop4:   in     r17,PINC         ; R17 <- Hunderter
         in     r16,PIND         ; R16 <- Zehner Einer
         rcall  bcd2dual         ; 
         brcc   loop5            ;
         sbi    PORTB,PB7        ; C = 1: PB7 an
         rjmp   loop6            ;
loop5:   cbi    PORTB,PB7        ; C = 0: PB7 aus
loop6:   in     r18,PINB         ; 
         in     r17,PINC         ;
         in     r16,PIND         ; 
         rcall  bcd4dual         ; 
         brcc   loop7            ; 
         sbi    PORTB,PB6        ; C = 1; PB6 an
         rjmp   loop4            ;
loop7:   cbi    PORTB,PB6        ; C = 0; PB6 aus
         rjmp   loop4            ; 
; Fehler 
error:   rjmp   error            ; Ausgabe kontrollieren
        .INCLUDE "BCD2dual.asm"  ; dual <- BCD 8bit  Carry=1: berlauf
        .INCLUDE "BCD4dual.asm"  ; dual <- BCD 16bit Carry=1: berlauf
        .INCLUDE "dual2bcd.asm"  ; BCD <- dual 8bit
        .INCLUDE "dual4bcd.asm"  ; BCD <- dual 16bit
        .EXIT                    ; Ende des Quelltextes



