

; test19.asm Test der Wurzelfunktion
; Port B: - 
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
        .INCLUDE "m16def.inc"    ; Deklarationen fr ATmega16
        .INCLUDE "Mkonsole.h"    ; Makros mit Konsolfunktionen
        .EQU    TAKT = 8000000   ; Systemtakt 8 MHz
        .EQU    NPUF = 80        ; Lnge des Eingabepuffers
        .DEF    akkul = r16      ; Arbeitsregister Low
        .DEF    akkuh = r17      ; Arbeitsregister High
        .CSEG                    ; Programm-Flash
         rjmp   start            ; Reset-Einsprung
        .ORG    $2A              ; Interrupteinsprnge bergehen
start:   ldi    akkul,LOW(RAMEND) ; Stapelzeiger laden
         out    SPL,akkul        ;
         ldi    akkul,HIGH(RAMEND);
         out    SPH,akkul        ;
         Minituart 9600          ; USART 9600 Baud bei Frequenz TAKT
         ldi    ZL,LOW(prompt*2) ; Z <- Adresse Ausgabetext
         ldi    ZH,HIGH(prompt*2);
; Arbeitsschleife 
loop:    rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  ein16            ; R17:R16 <- Radikand
         brcs   error            ; C = 1: Eingabefehler
         movw   r1:r0,r17:R16    ; R1:R0 <- Radikand
         rcall  sqrt             ; R1:R0 <- Wurzel
         movw   r17:r16,r1:r0    ; R17:R16 <- Wurzel
         rcall  ausdez16         ; ausgeben
         rjmp   loop             ;
;
; Fehlermeldung
error:   Mputkon '?'             ;
         Mputkon 7               ;
         rjmp   loop             ;
; interne Unterprogramme fr Gert und Betriebsart
ausz:    Mputch r16              ; direkte Ausgabe nach USART
         ret                     ; 
einz:    ld     r16,Y+           ; gepufferte Eingabe von USART aus (Y)
         ret                     ; 
; externe Unterprogramme String und Umwandlung
         .INCLUDE "gets.asm"     ; Zeile von USART nach SRAM Adresse in Y
         .INCLUDE "puts.asm"     ; Text aus Flash ausgeben
         .INCLUDE "einaus.h"     ; enthlt ausfp.asm und einfp.asm
         .INCLUDE "sqrt.asm"     ; R1:R0 <- SQRT(R1:R0)
;
; Ausgabetext
prompt:  .DB     10,13,"Radikand -> ",0,0
; SRAM-Bereich 
         .DSEG                   ; Datenbereich
puffer:  .BYTE   NPUF            ; Eingabepuffer fr gets
         .EXIT                   ; Ende des Quelltextes




