

; test14.asm Test Empfngerinterrupt
; Port B: Ausgabe empfangenes Zeichen
; Port D: PD0 = RXD  PD1 = TXD
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    TAKT = 8000000  ; Systemtakt 8 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .INCLUDE "Mkonsole.h"   ; fgt Konsolmakros ein
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    URXCaddr        ; Einsprung Empfngerinterrupt
        rjmp    igetch          ; nach Service-Programm
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapelzeiger
        out     SPL,akku        ; anlegen
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku        ;
        ser     akku            ; akku <- $ff
        out     DDRB,akku       ; Port B ist Ausgang
        Minituart  9600         ; USART initialisieren 9600 Baud
        .IFDEF  UCSRB           ; USART 
          sbi   UCSRB,RXCIE     ; Empfngerinterrupt freigeben
        .ELSE                   ; UART
          sbi   UCR,RXCIE       ; Empfngerinterrupt freigeben
        .ENDIF                  ;
         sei                    ; alle Interrupts global frei
loop:   rjmp    loop            ; 
; Servicefunktion durch ankommendes Zeichen gestartet
igetch: push    r16             ; Register retten
        in      r16,UDR         ; Zeichen abholen
        Mputch  r16             ; im Echo zurcksenden
        out     PORTB,r16       ; nach Port B
        pop     r16             ; Register zurck
        reti                    ;
       .EXIT                    ; Ende des Quelltextes

 

