

; t0warte.asm Unterprogramm Zeitverzgerung mit Timer0: 
; R16 = Faktor 1..255  R17 = Teilercode 001 bis 101 (1..5)
t0warte:cpi     r17,1     ; 1 Takt   untere Grenze 0
        brlo    t0warte3  ; 1 Takt   < 1: Fehler nicht ausfhren
        cpi     r17,5+1   ; 1 Takt   obere Grenze
        brsh    t0warte3  ; 1 Takte  > 5: Fehler nicht ausfhren 
        push    r16       ; 2 Takte: Register retten
        neg     r16       ; 1 Takt:  Faktor <- 2er Komplement
        out     TCNT0,r16 ; 1 Takt:  Timer0 <- Faktor
        in      r16,TCCR0 ; 1 Takt:  altes Steuerregister
        andi    r16,$f8   ; 1 Takt   Maske 1111 1000 alten Code lschen
        or      r16,r17   ; 1 Takt:  neuen Teilercode einbauen
        out     TCCR0,r16 ; 1 Takt:  Steuerung Timer0 starten
; Warteschleife auf Timer0-berlauf
t0warte1:in     r16,TIFR  ; 1 Takt:  Flags lesen
        sbrs    r16,TOV0  ; 2 Takte  berspringe bei TOV0 = 1: berlauf
        rjmp    t0warte1  ; 2 Takte  kein berlauf
        out     TIFR,r16  ; 1 Takt:  TOV0 lschen
        clr     r16       ; 1 Takt:  Teiler = 0
        out     TCCR0,r16 ; 1 Takt:  Timer0 stoppen
t0warte2:pop    r16       ; 2 Takte: Register zurck
t0warte3:ret              ; 4 Takte: Rcksprung
