 

; k6p8.asm  ATmega8  Gabellichtschranke Impulsmessung
; Port B: B7-B0: Ausgang Zhler fr fallende Flanken
; Port C: C5-C0: Eingang PC0 = Detector
; Port D: D7-D0: Ausgang Zhler fr steigende Flanken
; Konfiguration: interner Oszillator 1 MHz externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .DEF     fall = r17      ; Zhler fallende Flanken
        .DEF     stei = r18      ; Zhler steigende Flanken
        .DEF     eins = r19      ; Zhl-Eins
        .EQU     fuehl = PINC    ; Detektorport
        .EQU     pin = PC0       ; Detektoranschluss
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    $13              ; keine Interrupts
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND);
        out     SPH,akku         ;
        ldi     akku,$ff         ;
        out     DDRB,akku        ; Port B ist Ausgang
        out     DDRD,akku        ; Port D ist Ausgang
        clr     fall             ; Zhler fallende Flanken
        clr     stei             ; Zhler steigende Flanken
        ldi     eins,1           ; 1 zum addieren
        out     PORTB,fall       ; Anfangszustand
        out     PORTD,stei       ;
; High-Anfangs-Zustand
loop:   sbic    fuehl,pin        ; berspringe bei Low
        rjmp    loop             ; warte solange High
; fallende Flanke zhlen und ausgeben
        mov     akku,fall        ;
        add     akku,eins        ; zhlen
        rcall   daa              ; Dezimalkorrektur
        mov     fall,akku        ;
        out     PORTB,fall       ; ausgeben
loop1:  sbis    fuehl,pin        ; berspringe bei High
        rjmp    loop1            ; warte solange Low
; steigende Flanke zhlen und ausgeben
        mov     akku,stei        ;
        add     akku,eins        ; zhlen
        rcall   daa              ; Dezimalkorrektur
        mov     stei,akku        ;
        out     PORTD,stei       ; ausgeben
        rjmp    loop             ;
        .INCLUDE "daa.asm"       ; R16 Dezimalkorrektur
        .EXIT                    ; Ende des Quelltextes

