

; k6p10.asm  ATmega8  Gleichstrommotor  Steuerung mit 8bit PWM
; Port B: Ausgang PB1 OC1A PWM PB7 PB6 Eingabe Impulsgeber
; Port C: Ausgabe Ladewert Hunderter
; Port D: Ausgabe Ladewert Zehner  Einer
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister R17 R18 frei
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        sbi     DDRB,PB1        ; PB1 ist Ausgang OC1A
        ldi     akku,$ff        ;
        out     DDRC,akku       ; Port C ist Ausgang
        out     DDRD,akku       ; Port D ist Ausgang
; Timer1 PWM programmieren 8bit nicht invertiert Ladewert 0 - 255
        ldi     akku,(1 << COM1A1) | (0 << WGM11) | (1 << WGM10); 8bit 
        out     TCCR1A,akku     ; Steuerregister A Timer1
        ldi     akku,0b001      ; Taktteiler :1
        out     TCCR1B,akku     ; Steuerregister B Timer1 start
        ldi     XL,123          ; Startwert
        ldi     XH,0            ; 
; Arbeitsschleife 
loop:   sbic    PINB,PB7        ; berspringe bei Low
        rjmp    loop            ; warte solange High
; fallende Flanke Richtung bestimmen
        sbic    PINB,PB6        ; berspringe bei Low
        rjmp    loop1           ; springe bei High
        cpi     XL,255          ; aufwrts
        breq    loop2           ; Maximum 255 erreicht
        inc     XL              ; Drehzahl erhhen
        rjmp    loop2           ;
loop1:  tst     XL              ; abwrts
        breq    loop2           ; Minimum 0 erreicht
        dec     XL              ; Drehzahl vermindern
loop2:  rcall   warte20ms       ; entprellen
        out     OCR1AH,XH       ; Ladewert nach Komparator
        out     OCR1AL,XL       ; 
        mov     r17,XH          ; Ladewert dual
        mov     r16,XL          ; 
        rcall   dual4bcd        ; R17:R16 dual -> R18:R17:R16 BCD
        out     PORTC,r17       ; Hunderter
        out     PORTD,r16       ; Zehner    Einer
loop3:  sbis    PINB,PB7        ; berspringe bei High
        rjmp    loop3           ; warte solange Low
        rcall   warte20ms       ; entprellen
        rjmp    loop            ;
       .INCLUDE "dual4bcd.asm"  ; R17:R16 dual -> R18:R17:R16 BCD
       .INCLUDE "warte20ms.asm" ;
       .EXIT                    ; Ende des Quelltextes


