

; k4p23.asm  ATmega8  A/D-Wandler freilaufend Interrupt 
; Port B: High-Teil des 10bit Analogwertes 
; Port C: PC0 ADC0 10 kOhm Potentiometer
; Port D: Low-Teil des 10bit Analogwertes 
; Konfiguration: interner Oszillator; externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    ADCCaddr         ; Einsprung ADC fertig
        rjmp    holen            ; Service-Programm
        .ORG    $13              ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku         ;
        ldi     akku,$ff         ;
        out     DDRB,akku        ; Port B ist Ausgang
        out     DDRD,akku        ; Port D ist Ausgang
        ldi     akku,(0 << REFS1) | (0 << REFS0) | (0 << ADLAR) | 0;
        out     ADMUX,akku       ; Referenz, rechtsbndig, Kanal 0
        ldi     akku,(1<<ADEN)|(1<< ADSC)|(1<<ADFR)|(1<<ADPS1)|(1<<ADPS0);
        out     ADCSRA,akku      ; Wandler ein,starten,freilauf,Teiler 8
        sbi     ADCSRA,ADIE      ; Wandlerinterrupt frei
        sei                      ; Interrupts global frei
loop:   nop                      ; tu nix
        rjmp    loop             ;
; Interrupt-Serviceprogramm
holen:  push    akku             ; Register retten
        in      akku,ADCL        ; erst Low-Byte
        out     PORTD,akku       ; nach Port D
        in      akku,ADCH        ; dann High-Bits
        out     PORTB,akku       ; nach Port B
        pop     akku             ; Register zurck
        reti                     ; 
        .EXIT                    ; Ende des Quelltextes

