

; k2p9.asm ATmega8 Umwandlung binr nach Hexa-ASCII-Zeichen
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
loop:   in      akku,PIND       ; binre Eingabe: PD0 bis PD3          *
        andi    akku,$0F        ; Maske 0000 1111 PD4 bis PD7 lschen  *
        subi    akku,-$30       ; ADDI akku,+$30 codieren Ziffer 0 - 9 *
        cpi     akku,'9'+1      ; Buchstaben A - F ?                   *
        brlo    weiter          ; nein: war 0 - 9                      *
        subi    akku,-7         ; ADDI akku,+7 nach Buchstaben A - F   *
weiter: out     PORTB,akku      ; 0 - 9 bzw. A - F ausgeben            *
        rjmp    loop            ; neue Eingabe                         *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


