
 
; k2p25.asm ATmega8 Ganzzahlige Sinusfunktion analog ausgeben 
; 31 Takte * 360 Werte * 1 us -> 11 ms -> 90 Hz bei 1 MHz Systemtakt
; Port B: Ausgabe Digital/Analogwandler
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        ldi     r26,LOW(360)    ; R26 <- Endwert Low
        ldi     r27,HIGH(360)   ; R27 <- Endwert High
neu:    clr     r24             ; 1 Takt: R25:R24 <- Anfangswert 0 Grad
        clr     r25             ; 1 Takt
; Arbeitsschleife Abbruch nur mit Reset 12 Takte + 19 Takte Upro sinus
loop:   rcall   sinus           ; 3 Takte: R0 <- SIN(R25:R24)
        out     PORTB,r0        ; 1 Takt   Ausgabe auf Port B
        adiw    r24,1           ; 2 Takte: Winkel + 1
        cp      r24,r26         ; 1 Takt:  Winkel 360 Grad ?
        cpc     r25,r27         ; 1 Takt:
        breq    neu             ;   ja: 2 Takte + 2 Takte clr
        nop                     ; nein: 1 Takt  + 1 Takt nop + 2 Takte rjmp
        rjmp    loop            ; 2 Takte springe immer zum Ziel loop
; Unterprogramm sinus 
        .INCLUDE "sinus.asm"    ; R0 <- SIN(R25:R24)
        .EXIT                   ; Ende des Quelltextes
      


