

; k2p21.asm ATmega8 Software Interrupt INT1 intern ausgelst
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    INT1addr        ; Einsprung externer Interrupt INT1
        rjmp     taste          ; nach Servicprogramm
        .ORG    $2A             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        clr     akku            ; Dualzhler lschen
        out     PORTB,akku      ; und Anfangswert ausgeben
; Interrupt INT1 initialisieren
        in      akku,MCUCR      ; altes Steuerregister
        sbr     akku,1 << ISC11 ; setze  Bit ISC11
        cbr     akku,1 << ISC10 ; lsche Bit ISC10
        out     MCUCR,akku      ; ISC1x: 1 0 INT1 fallende Flanke
        in      akku,GICR       ; altes Freigaberegister
        sbr     akku,1 << INT1  ; setze Bit INT1: 
        out     GICR,akku       ; Interrupt INT1 freigegeben
        sei                     ; alle Interrupts global frei
; Software Interrupt und Zhler vorbereiten
        sbi     DDRD,DDD3       ; PD3 ist Ausgang
        sbi     PORTD,PD3       ; PD3 High
        clr     XL              ; 16bit Zhler lschen
        clr     XH              ;
; Hauptprogramm lst bei Zhlerberlauf Interrupt aus
loop:   adiw    XL,1            ; 16bit Zhler erhhen
        brne    loop            ; nicht Null
        cbi     PORTD,PD3       ;       Null: PD3 fallende Flanke
        nop                     ;             Pause
        sbi     PORTD,PD3       ;             PD3 wieder High
        rjmp    loop            ; weiter zhlen
;
; Serviceprogramm bedient externen Interrupt INT1 Taste PD3
taste:  push    r16             ; Register retten
        in      r16,SREG        ; Status 
        push    r16             ; retten
        in      r16,PORTB       ; alten Zhler
        inc     r16             ; um 1 erhhen
        out     PORTB,r16       ; neuen Zhler ausgeben
        pop     r16             ; 
        out     SREG,r16        ; Status zurck
        pop     r16             ;
        reti                    ; Rcksprung aus Serviceprogramm
        .EXIT                   ; Ende des Quelltextes

