

; k2p16.asm ATmega8 Flash nach SRAM-Liste kopieren und ausgeben
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
; Nullterminierten String aus Flash nach SRAM kopieren                 *
        ldi     ZL,LOW(ftab*2)  ; Z <- Tabellenadresse Flash           *
        ldi     ZH,HIGH(ftab*2) ;                                      *
        ldi     XL,LOW(stab)    ; X <- Listenadresse SRAM              *
        ldi     XH,HIGH(stab)   ;                                      *
        clr     r17             ; R17 = Zeichenzhler lschen          *
loop1:  lpm                     ; R0 <- Konstante aus Flash            *
        tst     r0              ; Endemarke Null ?                     *
        breq    lab1            ;   ja: fertig                         *
        st      X+,r0           ; nein: nach SRAM Adresse + 1          *
        adiw    ZL,1            ;       Flashadresse + 1               *
        inc     r17             ;       Zhler + 1                     *
        rjmp    loop1           ; Kopierschleife                       *
; Listenlnge speichern und Liste ausgeben                             *
lab1:   sts     lang,r17        ; Zeichenzhler vor Liste ablegen      *
loop2:  ldi     XL,LOW(stab)    ; X <- Listenadresse fr Ausgabe       *
        ldi     XH,HIGH(stab)   ;                                      *
        lds     r17,lang        ; R17 Zhler <- Listenlnge            *
loop3:  sbic    PIND,PIND7      ; Taster PIND7 Low ?                   *
        rjmp    loop3           ; warte solange High                   *
        ld      akku,X+         ; Akku <- Listenelement                *
        out     PORTB,akku      ; nach Port B ausgeben                 *
loop4:  sbis    PIND,PIND7      ; Taster PIND7 High ?                  *
        rjmp    loop4           ; warte solange Low                    *
        dec     r17             ; Zhler vermindern                    *
        brne    loop3           ; bis Zhler Null                      *
        rjmp    loop2           ; neuer Anfang                         *
; Konstanten hinter den Befehlen                                       *
ftab:  .DB "0123456789ABCDEF",0,0 ; Nullterminierter String            *
; Datenbereich im SRAM                                                 *
       .DSEG                    ; Datensegment ab $60                  *
lang:  .BYTE    1               ; 1 Byte fr Listenlnge               *
stab:  .BYTE    100             ; max. 100 Bytes fr Daten             *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


