

; k2p1.asm ATmega8 Einfhrendes Beispiel
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;******* Hier Testschleifen der Beispiele einbauen ********************
; Testschleife 7 Takte Low 7 Takte High Systemtakt/14 gem. PC0=70.7kHz*
loop:   in      akku,PIND       ; 1 Takt:  Eingabe Anschlsse Pin D   *
        out     PORTB,akku      ; 1 Takt:  Ausgabe Anschlsse Port B  *
        in      akku,PORTC      ; 1 Takt:  Eingabe alter Zhler       *
        inc     akku            ; 1 Takt:  Zhler erhhen             *
        out     PORTC,akku      ; 1 Takt:  neuen Zhler ausgeben      *
        rjmp    loop            ; 2 Takte: Sprung zum Schleifenanfang *
;**********************************************************************
        .EXIT                   ; Ende des Quelltextes


