


; Mmulsx16.asm Makro Softwaremultiplikation R3:R2:R1:R0 <-  @0:@1 * @2:@3 signed
       .MACRO   Mmulsx16 ; Nicht R0,R1,R2,R3,R4,R5
        push    r4      ; Register retten
        push    r5      ;
        push    @3      ;
        push    @2      ;
        push    @1      ;
        push    @0      ;
        push    r16     ; 
        ldi     r16,16  ; 
        mov     r4,r16  ; R4 = Durchlaufzhler
        pop     r16     ; 
; Vorzeichen der Faktoren behandeln
        mov     r5,@0   ; R5 <- High-Byte
        eor     r5,@2   ; R5 <- High EOR Low = Vorzeichen Produkt
        tst     @0      ; Vorzeichen ?
        brpl    Mmulsx16a ; positiv
        com     @0      ; negativ
        neg     @1      ;
        sbci    @0,-1   ;
Mmulsx16a:tst   @2      ;
        brpl    Mmulsx16b ; positiv
        com     @2      ; negativ
        neg     @3      ;
        sbci    @2,-1   ;
Mmulsx16b:clr   r3      ; Produkt_High lschen
        clr     r2      ; 
        mov     r0,@3   ; Produkt_Low = Multiplikator
        mov     r1,@2   ; 
        lsr     r1      ; Multiplikator_High rechts 
        ror     r0      ; Multiplikator_Low rechts nach Carry
Mmulsx16c:brcc   Mmulsx16d; Carry = 0: nicht addieren
        add     r2,@1   ;       = 1: bertrag + Multiplikand
        adc     r3,@0   ; 
Mmulsx16d:ror   r3      ; Carry und bertrag rechts
        ror     r2      ; Produkt_High rechts
        ror     r1      ; Multiplikator_High rechts 
        ror     r0      ; Multiplikator_Low rechts nach Carry
        dec     r4      ; Durchlaufzhler - 1
        brne    Mmulsx16c; bis Zhler Null
; Vorzeichen des Produktes behandeln
        tst     r5      ;
        brpl    Mmulsx16e ; Produkt positiv
        com     r0      ; Produkt 2er Komplement
        com     r1      ;
        com     r2      ;
        com     r3      ;
        clr     r4      ;
        inc     r4      ;
        add     r0,r4   ; + 1
        clr     r4      ;
        adc     r1,r4   ;
        adc     r2,r4   ;
        adc     r3,r4   ;
Mmulsx16e:pop   @0      ; Register zurck
        pop     @1      ;
        pop     @2      ;
        pop     @3      ;
        pop     r5      ; 
        pop     r4      ; 
        .ENDM           ; 