

; Minituart.asm: Makro UART bzw. USART initialisieren Symbol TAKT @0 Baudrate
       .MACRO    Minituart        ; @0 = Baudrate 
        push     r16              ; Register retten
        ldi      r16,TAKT/(8*@0) - 1 ; Teilerformel Baudrate 8*
        out      UBRRL,r16        ; UBRRH nach Reset 0 !
        sbi      UCSRA,U2X        ; 2*Baudrate Faktor 8* 
        ldi      r16,(1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0) ; 
        out      UCSRC,r16        ; asynchron 1 Stoppbit 8 Datenbits
        ldi      r16,(1<<RXEN)|(1<<TXEN) ; 
        out      UCSRB,r16        ; Empfnger und Sender ein
        in       r16,UDR          ; Empfnger leeren
        pop      r16              ; Register zurck
        .ENDM                     ; 