

// k7p7.c ATmega88 ersetzt zwei 74LS47 mit Hexaziffern
// Port B: PB0 - PB6 7Segmentausgnge rechts PB7 g-links
// Port C: PC0 - PC5 7Segmentausgnge links  PC6 Reset frei
// Port D: BCD Eingnge D7-D4 rechts D3-D0 links
// Fuses: Int. RC Osc. 1 MHz PB6 und PB7 als Port 
#include <avr/io.h>      // Deklarationen
// Codetabelle fr Ziffern 0 - 9 und A b C d E F fr gemeinsame Anode !!!
const unsigned char tab[] = \
{ 0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x78,0x00,0x18,0x08,0x03,0x46,0x21,0x06,0x0E };
void main (void)
{
 unsigned char links, rechts;
 DDRB = 0xff;                               // PB7 - PB0 sind Ausgnge
 DDRC = 0x7f;                               // PC6 - PC0 sind Ausgnge
 while (1)
 {
  links = tab[PIND & 0x0f];                // D3-D0 
  rechts = tab[ (PIND >> 4) & 0x0f];         // D7-D4 
  PORTC = links & 0x3f;                     // Segmente a-f links
  PORTB = rechts | ((links << 1) & 0x80);   // Segment a-g rechts g-Segment links
 } // Ende while
} // Ende main
