
// k4p6.c ATmega8  Timer1: Zeitmessung im Capture-Betrieb
// Port B: Eingabe PB0 = ICP1 Messfrequenz
// Port C: Ausgabe Dualzhler High 
// Port D: Ausgabe DualZhler Low
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>              // Deklarationen
#include <avr/signal.h>          // fr Interrupt
#include <avr/interrupt.h>       // fr Interrupt
#define TAKT 1000000UL           // Systemtakt intern ca. 1 MHz
SIGNAL(SIG_INPUT_CAPTURE1)      // Serviceroutine bei Timer1 Capture
{
 TCNT1 = 0;                     // Timer1 lschen
 PORTD = ICR1L;                 // Low-Zhler nach Port D
 PORTC = ICR1H;                 // High-Zhler nach Port C
} 
void main(void)                  // Hauptfunktion
{            
 DDRD = 0xff;                    // Port D ist Ausgang
 DDRC = 0xff;                    // Port C ist Ausgang
 OSCCAL = 0xC2;                  // RC Oszillator kalibrieren
 TCNT1 = 0;                      // Timer1 Anfangswert lschen
 TCCR1B = 0x81;                  // Timer1 1000 0001 Strunt. fallende Flanke Teiler1
 TIMSK |= (1 << TICIE1);        // Timer1 Capture Interrupt frei
 sei();                          // I = 1: alle Interrupts frei
 while(1) {}                     // Schleife tut nix mehr 
} // Ende main

