


; test18.asm Test der Festpunkt-Arithmetik
; Port B: - 
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
        .INCLUDE "m16def.inc"    ; Deklarationen fr ATmega16
        .INCLUDE "Mkonsole.h"    ; Makros mit Konsolfunktionen
        .INCLUDE "Mmuldiv.h"     ; enthlt Mfmulx8.asm 
        .EQU    TAKT = 8000000   ; Systemtakt 8 MHz
        .EQU    NPUF = 80        ; Lnge des Eingabepuffers
        .DEF    akkul = r16      ; Arbeitsregister Low
        .DEF    akkuh = r17      ; Arbeitsregister High
        .CSEG                    ; Programm-Flash
         rjmp   start            ; Reset-Einsprung
        .ORG    $2A              ; Interrupteinsprnge bergehen
start:   ldi    akkul,LOW(RAMEND) ; Stapelzeiger laden
         out    SPL,akkul        ;
         ldi    akkul,HIGH(RAMEND);
         out    SPH,akkul        ;
         Minituart 9600          ; USART 9600 Baud bei Frequenz TAKT
         ldi    ZL,LOW(prompt*2) ; Z <- Adresse Ausgabetext
         ldi    ZH,HIGH(prompt*2);
; Arbeitsschleife 
loop:    rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  einfp            ; R17:R16 <- 1.Operand
         brcc   PC+2             ; C = 0: kein Eingabefehler
         rjmp   error            ;
         movw   r19:r18,r17:r16  ; R19:R18 <- 1.Operand
         movw   r21:r20,r17:r16  ; R21:R20 <- 1.Operand
         rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  einfp            ; R17:R16 <- 2.Operand
         movw   r23:r22,r17:r16  ; R23:R22 <- 2.Operand
         brcc   PC+2             ; C = 0: kein Eingabefehler
         rjmp   error            ;
; Test der Addition
         add    r16,r18          ; addiere Low
         adc    r17,r19          ; addiere High + bertrag
         brcc   loop1            ; kein bertrag
         Mputkon ' '             ;
         Mputkon 'C'             ;
loop1:   rcall  ausfp            ; Summe ausgeben
; Test der Subtraktion
         movw   r17:r16,r19:r18  ; R17:R16 <- 1. Operand
         sub    r16,r22          ; subtrahiere Low
         sbc    r17,r23          ; subtrahiere High - Borgen
         brcc   loop2            ; kein Borgen
         Mputkon ' '             ;
         Mputkon 'C'             ;
loop2:   rcall  ausfp            ; Differenz ausgeben
; Test des 8bit fmul-Befehls 
         Mputkon ' '             ; lz
         Mputkon '*'             ; Marke
         fmul   r21,r23          ; nur High-Teile multiplizieren
         brcc   loop3            ; kein bertrag
         Mputkon ' '             ;
         Mputkon 'C'             ;
loop3:   movw   r17:r16,r1:r0    ; 
         rcall  ausfp            ;Produkt ausgeben
; Test des 8bit Mfmulx8-Makros 
         Mputkon ' '             ; lz
         Mputkon '*'             ; Marke
         Mfmulx8 r21,r23         ; nur High-Teile multiplizieren
         brcc   loop4            ; kein bertrag
         Mputkon ' '             ;
         Mputkon 'C'             ;
loop4:   movw   r17:r16,r1:r0    ;
         rcall  ausfp            ; Produkt ausgeben
         rjmp   loop             ;
;
; Fehlermeldung
error:   Mputkon '?'             ;
         Mputkon 7               ;
         rjmp   loop             ;
; interne Unterprogramme fr Gert und Betriebsart
ausz:    Mputch r16              ; direkte Ausgabe nach USART
         ret                     ; 
einz:    ld     r16,Y+           ; gepufferte Eingabe von USART aus (Y)
         ret                     ; 
; externe Unterprogramme String und Umwandlung
         .INCLUDE "gets.asm"     ; Zeile von USART nach SRAM Adresse in Y
         .INCLUDE "puts.asm"     ; Text aus Flash ausgeben
         .INCLUDE "einaus.h"     ; enthlt ausfp.asm und einfp.asm
;
; Ausgabetext
prompt:  .DB     10,13,"Eingabe -> ",0
; SRAM-Bereich 
         .DSEG                   ; Datenbereich
puffer:  .BYTE   NPUF            ; Eingabepuffer fr gets
         .EXIT                   ; Ende des Quelltextes



