


; test11.asm  Test EEPROM-Interrupt Messung der Systemtakte beim Schreiben
; Port B: Ausgabe LED High-Teil des Schreibtaktzhlers
; Port D: Eingabe Taste PIND0  Ausgabe PD7..PD1: Low-Teil Taktzhler
; gemessen: $4307 = 17159 Durchlufe * 4 = 68636 Systemtakte / 8 MHz = 8579.5 ms
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16 
        .EQU    TAKT = 8000000   ; Takt 8 MHz 
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    hilf = r17      ; Hilfsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    ERDYaddr        ; $01E Einsprung Schreiben fertig
        jmp     fertig          ; nach Serviceprogramm
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        ldi     akku,$fe        ; Bitmuster 1111 1110
        out     DDRD,akku       ; Port D Bit_7 bis Bit_1 Ausgang
        ldi     ZL,LOW(evar)    ; Z <- EEPROM-Adresse der Variablen
        ldi     ZH,HIGH(evar)   ; 
        cbi     EECR,EEWE       ; EEWE = 0: kein Schreiben
; Testschleife mit Interrupt
loop:   sbic    PIND,PIND0      ; warte auf fallende Flanke
        rjmp    loop            ; bis PIND7 Low
        rcall   warte20ms       ;
        ldi     akku,$55        ; R16 <- Testwert
        mov     hilf,akku       ; Vergleichswert
        clr     r24             ; Zhler Low lschen
        clr     r25             ; Zhler High lschen
        rcall   weprom          ; R16 -> EEPROM schreiben EEWE = 1 
        sbi     EECR,EERIE      ; EERIE = 1 EEPROM-Interrupt frei
        sei                     ; I = 1     alle Interrupts frei
        clt                     ; Marke T <- 0
; warte auf EEPROM-Interrupt 4 Takte 
warte:  adiw    r24,1           ; 2 Takte: Zhler + 1
        brtc    warte           ; 2 Takte: springe bei T = 0: kein Ende
        cli                     ; I = 0     alle Interrupts gesperrt
        cbi     EECR,EERIE      ; EERIE = 0 EEPROM-Interrupt gesperrt
; warte auf steigende Flanke PIND7
flanke: sbis    PIND,PIND0      ; warte auf steigende Flanke
        rjmp    flanke          ; bis PIND7 High
        rcall   warte20ms       ;
        clr     akku            ; lschen fr Test
        rcall   reprom          ; R16 <- EEPROM lesen
        adiw    ZL,1            ; erhhe EEPROM-Adresse
        cp      akku,hilf       ; Kontrolle
        breq    loop            ; gut: weiter
        ldi     akku,$ff        ; Fehler:
        out     PORTB,akku      ;
        rjmp    loop            ; 
; Interrupt-Einsprung Ende Schreibvorgang EEWE = 0 durch Steuerung
fertig: out     PORTB,r25       ; Zhler High Port B
        out     PORTD,r24       ; Zhler Low Port D
        set                     ; Marke T <- 1: Ende
        reti                    ; Rcksprung nach Unterbrechung
; externe Unterprogramme fr EEPROM-Zugriff R16=Daten   Z=Adresse
       .INCLUDE "reprom.asm"    ; Read EEPROM 
       .INCLUDE "weprom.asm"    ; Write EEPROM
       .INCLUDE "warte20ms.asm" ;
;
; EEPROM-Bereich 
       .ESEG                    ; EEPROM-Segment
evar:  .BYTE     100            ; Variable 100 Bytes
       .EXIT                    ; Ende des Quelltextes

