

; pctast.asm PC-Tastatur R16 <- ASCII-Code  R17 <- Scancode
; Testversion nur Zustandstaste Shift-links
        .EQU    pcport = PINB   ; Port des PC-Anschlusses
        .EQU    pctakt = PB5    ; Takteingang
        .EQU    pcdat  = PB3    ; Dateneingang
pctast:  push   r0              ; Register retten
         push   ZL              ;
         push   ZH              ;
; warte auf Taste Rckgabe: R17 = Scancode R16 = ASCII-Code oder $00
pctast1: rcall  pcscan          ; R16 <- Scancode 
         cpi    r16,$12         ; Shift-links ?
         brne   pctast2         ; nein
         ldi    zustand,$80     ;   ja: Zustand ein
         rjmp   pctast1         ; Eingabe bis Break
pctast2: cpi    r16,$F0         ; Break-Code ?
         brne   pctast1         ; nein: warten
         rcall  pcscan          ;   ja: Folgezeichen
         cpi    r16,$12         ; Shift-links ?
         brne   pctast3         ; nein:
         ldi    zustand,$00     ;   ja: Zustand aud
         rjmp   pctast1         ; Eingabe bis Break
pctast3: mov    r17,r16         ; R17 <- Scancode
         or     r16,zustand     ; Zustandscode einbauen
         ldi    ZL,LOW(pctab*2) ; Z <- Anfangsadresse Codetabelle
         ldi    ZH,HIGH(pctab*2);
         add    ZL,r16          ; + Abstand Scancode
         clr    r16             ; R16 <- 0 Carry bleibt
         adc    ZH,r16          ;      + 0 + Carry
         lpm                    ; R0 <- Tabellenwert
         mov    r16,r0          ; R16 <- ASCII-Code
         pop    ZH              ; Register zurck
         pop    ZL              ;
         pop    r0              ;
         ret                    ; R16 = ASCII-Code R17 = Scancode

; Codetabelle ASCII-Codes oder 0x00
pctab: .DB 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5e,0x0 ;
       .DB 0x0,0x0,0x0,0x0,0x0,'Q','1',0x0,0x0,0x0,'Y','S','A','W','2', 0x0 ;
       .DB 0x0,'C','X','D','E','4','3',0x0,'F',' ','V',0x0,'T','R','5', 0x0 ;
       .DB 0x0,'N','B','H','G','Z','6',0x0,0x0,0x0,'M','J','U','7','8', 0x0 ;
       .DB 0x0,',','K','I','O','0','9',0x0,0x0,'.','-','L','','P','', 0x0 ;
       .DB 0x0,0x0,'',0x0,'',''',0x0,0x0,0x0,0x0,0x0,'+',0x0,'#',0x0, 0x0 ;
       .DB 0x0,'<',0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0, 0x0 ;
       .DB 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0, 0x0 ;
; Codetabelle $80 bis $ff nicht in Testversion ausgewertet
       .DB 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5e,0x0 ;
       .DB 0x0,0x0,0x0,0x0,0x0,'q','1',0x0,0x0,0x0,'y','s','a','w','"', 0x0 ;
       .DB 0x0,'c','x','d','e','$','',0x0,'f',' ','v',0x0,'t','r','&', 0x0 ;
       .DB 0x0,'n','b','h','g','z','&',0x0,0x0,0x0,'m','j','u','7','(', 0x0 ;
       .DB 0x0,',','k','i','o','=',')',0x0,0x0,':','-','l','','p','?', 0x0 ;
       .DB 0x0,0x0,'',0x0,'',''',0x0,0x0,0x0,0x0,0x0,'*',0x0,''',0x0, 0x0 ;
       .DB 0x0,'>',0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0, 0x0 ;
       .DB 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0, 0x0 ;
;
; pcscan: R16 <- Datenbyte bei steigender Taktflanke abtasten
pcscan:  push   r17             ; Register retten
         clr    r16             ; Empfangsbyte lschen
         ldi    r17,8           ; R17 = Schiebezhler fr 8 Datenbits
; warte auf fallende Start-Taktflanke und Startbit
pcscan1: sbic   pcport,pctakt   ; berspringe wenn Takt Low
         rjmp   pcscan1         ; warte bei Takt High Ruhezustand
pcscan2: sbis   pcport,pctakt   ; berspringe wenn Takt wieder High
         rjmp   pcscan2         ; warte bei Takt Low Startbit
pcscan3: sbic   pcport,pctakt   ; berspringe wenn Takt Low
         rjmp   pcscan3         ; warte solange Takt High
pcscan4: sbis   pcport,pctakt   ; berspringe wenn Takt High
         rjmp   pcscan4         ; warte solange Takt Low Datenbit
; steigende Taktflanke erkannt Datenleitung abtasten
         lsr    r16             ; altes Byte rechts Bit_7 = 0
         sbic   pcport,pcdat    ; berspringe wenn Datenbit Low
         ori    r16,$80         ; setze Bit_7 = 1 wenn Datenbit High
pcscan5: sbic   pcport,pctakt   ; berspringe wenn Takt Low
         rjmp   pcscan5         ; warte solange Takt High 
         dec    r17             ; Bitzhler - 1
         brne   pcscan4         ; bis 8 Datenbits zusammengeschoben
; Parittsbit und Stoppbit abwarten
         ldi    r17,2           ; Zhler fr Parittsbit und Stoppbit
pcscan6: sbic   pcport,pctakt   ; berspringe wenn Takt Low
         rjmp   pcscan6         ; warte bei Takt High 
pcscan7: sbis   pcport,pctakt   ; berspringe wenn Takt wieder High
         rjmp   pcscan7         ; warte bei Takt Low
         dec    r17             ; Bitzhler - 1
         brne   pcscan6         ; bis beide Bits abgetastet
         pop    r17             ; Register zurck
         ret                    ; Rcksprung R16 = Datenbyte



