

; lcd4func.asm Funktionstasten zur Cursorkontrolle R16 = Code 1..9
lcd4func:tst    r16             ; Bereichskonstrolle
        breq    lcd4funcx       ; 0 nicht im Bereich
        cpi     r16,9+1         ; > 9 ?
        brsh    lcd4funcx       ; ja: nicht im Bereich
        push    r0              ; Register retten fr alle Upros
        push    r16             ;
        push    r17             ;
        push    r18             ; 
        push    ZL              ;
        push    ZH              ;
        ldi     ZL,LOW(functab*2)  ;Z <- Adresse Sprungtabelle
        ldi     ZH,HIGH(functab*2) ;
        dec     r16             ; Code 1..9 -> 0..8 fr berechnetes cal
        lsl     r16             ; Abstand = Code * 2
        add     ZL,r16          ; + Abstand
        clr     r16             ;
        adc     ZH,r16          ; + bertrag
        lpm                     ; R0 <- Low-Byte
        mov     r16,r0          ; R16 <- Low-Byte
        adiw    ZL,1            ; 
        lpm                     ; R0 <- High-Byte
        mov     ZL,r16          ; ZL <- Low-Byte
        mov     ZH,r0           ; HH <- High-Byte
        icall                   ; indirekter Unterprogrammaufruf
        pop     ZH              ; Register zurck fr alle Upros
        pop     ZL              ;
        pop     r18             ; 
        pop     r17             ;
        pop     r16             ;
        pop     r0              ;
lcd4funcx:ret                   ;
; Sprungtabelle der Funktionsunterprogramme
functab: .DW    func1,func2,func3,func4,func5,func6,func7,func8,func9
;
func1:  ldi     r16,' '         ; Code 1: Leerzeichen ausgeben
        rcall   lcd4put         ; 
        rcall   lcd4cur         ; Cursorkontrolle
        ret                     ;
;
func2:  ret                     ; Code 2 nicht belegt
;
func3:  ret                     ; Code 3 nicht belegt
;
func4:  cpi     curpos,$50      ; Code 4: Cursor ab unterste Zeile ?
        brsh    func4d          ; ja: keine Wirkung
        cpi     curpos,$40      ; 2. Zeile ?
        brlo    func4a          ; nein
        subi    curpos,$30      ; ja. nach 3.Zeile $30
        rjmp    func4c          ; 
func4a: cpi     curpos,$10      ; 3. Zeile ?
        brlo    func4b          ; nein
        subi    curpos,-$40     ; ja: nach 4. Zeile
        rjmp    func4c          ;
func4b: subi    curpos,-$40     ; 1.Zeile nach 2.Zeile
func4c: mov     r16,curpos      ; neue Cursorposition
        ori     r16,$80         ; Steuerbit dazu
        rcall   lcd4com         ; Cursor positionieren
func4d: ret                     ;
;
func5:  cpi     curpos,$10      ; Code 5 Cursor auf oberste Zeile ?
        brlo    func5d          ; ja: keine Wirkung
        cpi     curpos,$20      ; 3. Zeile ?
        brsh    func5a          ; nein
        subi    curpos,-$30     ; ja: nach 2.Zeile
        rjmp    func5c          ;
func5a: cpi     curpos,$50      ; 2. Zeile ?
        brsh    func5b          ; nein
        subi    curpos,$40      ; ja: nach 1. Zeile
        rjmp    func5c          ;
func5b: subi    curpos,$40      ; 4.Zeile nach 3.Zeile
func5c: mov     r16,curpos      ; R16 <- Cursorposition
        ori     r16,$80         ; Steuerbit dazu
        rcall   lcd4com         ; Cursor positionieren
func5d: ret                     ;
;
func6:  mov     r16,curpos      ; Code 6 Cursor links
        andi    r16,0b00001111  ; Maske fr Spalte
        cpi     r16,$00         ; am Anfang ?
        breq    func6a          ;   ja: keine Wirkung
        dec     curpos          ; nein:  Position rck
        ldi     r16,0b00010000  ;       Cursor links
        rcall   lcd4com         ;
func6a: ret                     ;
;
func7:  mov     r16,curpos      ; Code 7 ? Cursor rechts
        andi    r16,0b00001111  ; Maske fr Spalte
        cpi     r16,$0F         ; am Ende ?
        breq    func7a          ;   ja: keine Wirkung:
        inc     curpos          ; nein: nchste Position
        ldi     r16,0b00010100  ;       Cursor rechts
        rcall   lcd4com         ;       Kommando ausgeben
func7a: ret                     ; 
;
func8:  ldi     r16,$01         ; Code 8 Display lschen
        rcall   lcd4com         ;
        ldi     r16,$02         ; Cursor home
        rcall   lcd4com         ; 
        clr     curpos          ; Cursor 0 
        ret                     ;
;
func9:  andi    curpos,0b11110000 ; Code 9 return Zeile lschen und Anfang
        mov     r16,curpos      ; R16 <- Cursorposition
        ori     r16,$80         ; Steuerbit dazu
        mov     r17,r16         ; R17 <- Steuercode fr Zeilenanfang
        rcall   lcd4com         ; Cursor am Zeilenanfang
        ldi     r18,16          ; R18 = Zhler fr 16 Leerzeichen
func9a: ldi     r16,' '         ; R16 <- Leerzeichen
        rcall   lcd4put         ; ausgeben
        dec     r18             ; Zhler - 1
        brne    func9a          ;
        mov     r16,r17         ; R16 <- Steuercode fr Zeilenanfang
        rcall   lcd4com         ;
        ret                     ; 
