



; lcd4comfast.asm R16 = 8bit Kommando nach 4bit Bus
lcd4comfast:
        push    r16             ; Register mit Zeichen retten
        push    r17             ;
        .IF     lcdbus =='l'    ; wenn 4bit LCD an Low-Port
        swap    r16             ; R16 <= High | Low
       .ENDIF                ; 
        out     lcdpdat,r16     ; High-Nibble ausgeben
        cbi     lcdprs,lcdrs    ; RS = Low Kommandoausgabe
        sbi     lcdpen,lcden    ; E = High
        ldi     r17,(TAKT/2000000) + 1; 
lcd4comfast1:                   ; ca. 2 us warten
        nop                     ; 1 Takt
        dec     r17             ; 1 Takt
        brne    lcd4comfast1    ; 2 Takte
        cbi     lcdpen,lcden    ; E Low: fallende Flanke
        swap    r16             ; Nibbles vertauschen
        out     lcdpdat,r16     ; Low-Nibble
        cbi     lcdprs,lcdrs    ; RS = Low: Kommandoausgabe
        sbi     lcdpen,lcden    ; E High
        ldi     r17,(TAKT/2000000) + 1; 
lcd4comfast2:                   ; > 2 us warten
        nop                     ; 1 Takt
        dec     r17             ; 1 Takt
        brne    lcd4comfast2    ; 2 Takte
        cbi     lcdpen,lcden    ; E Low: fallende Flanke
        clr     r16             ; alle Ausgnge
        out     lcdpdat,r16     ; auf Low
        ldi     r17,250         ; 250*4 * Taktperiode
lcd4comfast3:                   ; > 120 us warten
        nop                     ; 1 Takt
        dec     r17             ; 1 Takt
        brne    lcd4comfast3    ; 2 Takte
        pop     r17             ; Register zurck
        pop     r16             ; 
        ret                     ;