

; k6p2.asm ATtiny2313  9stellige Multiplexanzeige
; Port B: PB7 - PB0 Ausgabe aller Segment-Katoden
; Port D: PD3 - PD0 Ausgabe Auswahl Anoden  PD6: Eingang Taster
; Konfiguration: externer Quarz 3-8 MHz  externes Reset-Signal frei
; externer Quarz 3.072 MHz : 256 = 12000 = Zhler 12 fr 1 kHz 1 ms
        .INCLUDE    "tn2313def.inc" ; Deklarationen fr Tiny2313
        .DEF        akku = r16      ; R16 = Arbeitsregister
        .DEF        zael = r17      ; R17 = Interrupt-Durchlaufzhler
        .DEF        durch = r18     ; R18 = Ziffernzhler
        .DEF        ziff = r19      ; R19 = Stellenzhler
        .CSEG                       ; Programm-Flash
        rjmp        start           ; Reset-Einsprung
        .ORG        OVF0addr        ; Einsprung Timer0 berlauf
        rjmp        muxen           ;
        .ORG        $13             ; 
start:  ldi         akku,LOW(RAMEND); Stapel anlegen
        out         SPL,akku        ; kein SPH !
        ldi         akku,$ff        ; 
        out         DDRB,akku       ; Port B ist Ausgang
        ldi         akku,0b00001111 ; PD6 Eingang PD3-PD0 Ausgang
        out         DDRD,akku       ; 
        rcall       loesch          ; alle Stellen  lschen
; Multiplex-Ausgabezeiger YH:YL vorbereiten
        ldi         YL,LOW(aus)     ; Y = Anfangsadresse R0
        ldi         YH,HIGH(aus)    ; 
        ldi         durch,9         ; 9 Stellen
        ldi         zael,12         ; Interrupt-Durchlaufzhler
; Timer0 und Interrupt vorbereiten
        ldi         akku, (1 << CS00); 001 Systemtakt / 1
        out         TCCR0,akku      ; Teilerfaktor 1
        ldi         akku, (1 << TOIE0); Timer0 Interrupt frei
        out         TIMSK,akku      ; 
        sei                         ; globale Interruptfreigabe 
; Arbeitsschleife fallende Flanke PD6 lscht Zhler
loop:   sbic        PIND,PIND6      ; warte auf fallende Flanke
        rjmp        loop            ;
        cli                         ; Interrupt gesperrt
        rcall       loesch          ; keine Anzeige
        sei                         ; Interrupt frei
loop1:  sbis        PIND,PIND6      ; warte auf steigende Flanke
        rjmp        loop1           ;
        rjmp        loop            ; Schleife
;Interrupt-Einsprung durch Timer0 berlauf
muxen:  push        r16             ; R16 nach Stapel
        in          r16,SREG        ; Statusregister
        push        r16             ; nach Stapel
        dec         zael            ; Interruptzhler - 1
        brne        muxenex         ; noch keine Millisekunde
        ldi         zael,12         ; nach einer Millisekunde 
; neue Ausgabe laufender Zeiger in YH:YL  
        ld          akku,Y+         ; R16 = laufende Dezimalstelle
        dec         durch           ; 9 Durchlufe Beginn mit Stelle 8!
        rcall       coden           ; R16 Dezimal nach Siebensegmentcode
        out         PORTB,akku      ; nach Katoden
        out         PORTD,durch     ; nach Anodenauswahl
        rcall       zaehler         ; Ausgabe-Zhler erhhen
        tst         durch           ; Zhler auf 0 testen
        brne        muxenex         ; noch nicht Stelle 0 ausgegeben
        ldi         YL,LOW(aus)     ; neue Anfangswerte
        ldi         YH,HIGH(aus)    ; fr Multiplexanzeige
        ldi         durch,9         ; fr Stellenzhler
muxenex:pop         r16             ; Statusregister
        out         SREG,r16        ; vom Stapel
        pop         r16             ; R16 vom Stapel
        reti                        ; Rckkehr aus Service
; Unterprogramm alle Stellen lschen
loesch: ldi         XL,LOW(aus)     ; keine Register gerettet!
        ldi         XH,HIGH(aus)    ;
        ldi         ziff,9          ;
        clr         r16             ;
loesch1:st          X+,r16          ;
        dec         ziff            ;
        brne        loesch1         ;
        ret                         ; 
; Unterprogramm Zhler +1 Zeiger XH:XL
zaehler:ldi         XL,LOW(aus)     ; keine Register gerettet!
        ldi         XH,HIGH(aus)    ;
        ldi         ziff,9          ; Zhler 9 Dezimalstellen
zaehle1:ld          akku,X          ; Dezimalstelle laden
        inc         akku            ; Stelle + 1
        cpi         akku,10         ; bertrag ?
        breq        zaehle2         ;   ja:
        st          X+,akku         ; nein: speichern
        rjmp        zaehle3         ; fertig
zaehle2:clr         akku            ; Stelle Null
        st          X+,akku         ;
        dec         ziff            ; hchste Stelle ?
        brne        zaehle1         ; nein
zaehle3:ret                         ;
; Unterprogramm R16= Dezimalstelle nach R16 = Siebensegmentcode
coden:  ldi         ZL,LOW(ctab*2)  ; keine Register gerettet!
        ldi         ZH,HIGH(ctab*2) ; Z = Zeiger auf Tabelle
        add         ZL,r16          ; + Dezimalstelle
        clr         r16             ; Carry unverndert
        adc         ZH,r16          ; 
        lpm         r16,Z           ; R16 = Tabellenwert
        ret                         ; Rckkehr 
ctab:   .DB $3f,$06,$5b,$4f,$66,$6d,$7d,$07,$7f,$6f ; Ziffern 0 - 9
; Zhler und Ausgabespeicher im SRAM angelegt
        .DSEG                       ; SRAM-Bereich
aus:    .BYTE       9               ; 9 Dezimalstellen
        .EXIT
