

; k4p14.asm  ATmega8  USART Test der Konsolunterprogramme
; Port B: - 
; Port C: -
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .EQU    baud = 9600     ; Baudrate
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ;        
        rcall   initusart2      ; USART initialisieren doppelte Baudrate
neu:    ldi     akku,'>'        ; Prompt >
        rcall   putch           ;  ausgeben
loop:   rcall   getch           ; Zeichen ohne Echo empfangen
        cpi     akku,$1b        ; Steuerzeichen Escape ?
        breq    warte           ; nein: kein Echo
        rcall   putch           ;   ja: Echo
        rjmp    loop            ; und neue Eingabe
; Ausgabeschleife mit * bis Abbruch mit beliebiger Taste
warte:  ldi     akku,'*'        ; Sterne 
        rcall   putch           ; ausgeben
        rcall   kbhit           ; Empfnger testen
        tst     akku            ; Akku Null Zeichen da ?
        breq    warte           ; Null: kein Zeichen da
        rjmp    neu             ; ungleich Null: Abbruchzeichen nicht ausgeben
; Konsolunterprogramme einfgen
       .INCLUDE "konsole.h"     ; initusart2,putch,getch,getche,kbhit
        .EXIT                   ; Ende des Quelltextes

