

; k4p12.asm  ATmega8  Watchdog Timer
; Port B: Restzeit Einer Zehner 
; Port C: Restzeit Hunderter
; Port D: Taste PD7 beruhigt Wachhund
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal, WDT aus
        .INCLUDE  "m8def.inc"     ; Deklarationen fr Mega8
        .EQU    takt = 1000000    ; Systemtakt ca. 1 MHz intern
        .DEF    akku = r16        ; Arbeitsregister
        .DEF    zael = r18        ; Zhler
       .CSEG                      ; Programmbereich
        rjmp    start             ;
        .ORG    $2A               ; Interrupts nicht besetzt
start:  ldi     akku,LOW(RAMEND)  ; Stapelzeiger
        out     SPL,akku          ; anlegen
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku          ; 
        ser     akku              ;
        out     DDRB,akku         ; Port B ist Ausgang
        out     DDRC,akku         ; Port C ist Ausgang
; nach Reset 10 Sekunden 00 00 anzeigen
        ldi     zael,10           ; Faktor fr 10 Sekunden
sek10:  ldi     akku,100          ;
        rcall   wartex10ms        ; 1 sek warten
        dec     zael              ;
        brne    sek10             ;
; Wachhund scharf machen
        ldi     akku,(1<<WDCE) | (1<<WDE) ;
        out     WDTCR,akku        ; Programmierung vorbereiten
        ldi     akku,(0<<WDCE) | (1<<WDE) | (1<<WDP2) | (1<<WDP1) | (1<<WDP0)
        out     WDTCR,akku        ; Teiler 2048 ca. 2 sek einstellen
        ldi     zael,200          ; Restzeitzhler fr 2000 msek
; Arbeitsschleife innerhalb von 2 Sekunden Taste PD7 drcken
loop:   sbic    PIND,PD7          ; berspringe wenn Taste Low
        rjmp    next              ; bei High gehts weiter
        wdr                       ; bei Low Wachhund beruhigen
        ldi     zael,200          ; Restzeitzhler 2000 msek
next:   mov     akku,zael         ;
        rcall   dual2bcd          ; nach R17:R16 BCD
        out     PORTB,akku        ; Hundertstel 
        out     PORTC,r17         ; Sekunde
        ldi     akku,1            ; Faktor
        rcall   wartex10ms        ; 10 ms warten
        dec     zael              ; Restzeitzhler vermindern
        rjmp    loop              ;
        .INCLUDE "wartex10ms.asm" ; warte 10 * R16 Millisekunden 
        .INCLUDE "dual2bcd.asm"   ; R16 dual nach R17:R16 BCD
        .EXIT                     ; Ende des Quelltextes
