

; k4p1.asm ATmega8 internen Oszillator temporr kalibrieren
; Port B: Ausgabe aktuelles Kalibrierungsbyte
; Port C: Ausgabe Dualzhler PC0 = Systemtakt / 20
; Port D: Eingabe Testwert fr das Kalibrierungsbyte
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
; Testschleife 10 Takte Low 10 Takte High Systemtakt/20 theoret. 50 kHz
loop:   in      akku,PORTC      ; 1 Takt:  Eingabe alter Zhler
        inc     akku            ; 1 Takt:  Zhler erhhen
        out     PORTC,akku      ; 1 Takt:  neuen Zhler ausgeben
        in      akku,PIND       ; 1 Takt:  neue Eingabe
        out     OSCCAL,akku     ; 1 Takt:  nach Kalibrierungsregister
        nop                     ; 1 Takt   warten
        in      akku,OSCCAL     ; 1 Takt   rcklesen
        out     PORTB,akku      ; 1 Takt   Kontrollausgabe
        rjmp    loop            ; 2 Takte: Sprung zum Schleifenanfang 
        .EXIT                   ; Ende des Quelltextes


