

; k2p22.asm ATmega8 USART-Unterprogramme fr PC als Terminal
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: PC-Terminal: PD0:RXD PD1:TXD PD2-PD7 frei Taster
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern
        .EQU    BAUD = 9600     ; Baudrate fr USART
        .EQU    NPUF = 80       ; Lnge Eingabepuffer im SRAM
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        out     DDRC,akku       ; Richtung Port C ist Ausgang
        rcall   initusart2      ; USART doppelte Baudrate mit BAUD und takt
loop:   ldi     ZL,LOW(text*2)  ; Z <- Stringadresse im Flash
        ldi     ZH,HIGH(text*2) ;
        rcall   puts            ; cr lf Text ausgeben
        ldi     YL,LOW(puffer)  ; Y <- Eingabeadresse im SRAM
        ldi     YH,HIGH(puffer) ;
        rcall   gets            ; String nach SRAM
        ld      akku,Y+         ; 1. Zeichen
        rcall   putch           ; zur Kontrolle zurcksenden
        out     PORTB,akku      ; zur Kontrolle auf PORTB ausgeben
        rjmp    loop            ;
;
        .INCLUDE "initusart2.asm" ; USART initialisieren
        .INCLUDE "putch.asm"    ;   R16 senden
        .INCLUDE "puts.asm"     ;   String aus (Z) senden
        .INCLUDE "getch.asm"    ;   Zeichen nach R16 empfangen
        .INCLUDE "gets.asm"     ;   String nach (Y) empfangen
;
text:   .DB 10,13,"Eingabe ->",0,0 ; neue Zeile und Text ausgeben
;
        .DSEG                   ;
puffer: .BYTE     NPUF          ; Pufferspeicher fr Eingabe
        .EXIT                   ; Ende des Quelltextes

