

; k2p13.asm ATmega8 Spruntabelle als Fallunterscheidung
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
loop:   in      akku,PIND       ; Auswahlwert vom Port D eingeben      *
        andi    akku,0b00000011 ; Bereich 0 .. 3 begrenzen             *
        lsl     akku            ; Abstand = Eingabe * 2 (zwei Bytes)   *
; Adresse des Eintrags berechnen                                       *
        ldi     ZL,LOW(stab*2)  ; Z <- Tabellenanfangsadresse          *
        ldi     ZH,HIGH(stab*2) ;                                      *
        add     ZL,akku         ; ZL <- Anfangsadresse + Abstand       *
        clr     akku            ; Akku <- Null Carry unverndert       *
        adc     ZH,akku         ; Wortaddition: Null + Carry           *
; Sprungadresse aus Tabelle entnehmen                                  *
        lpm                     ; R0 <- Low-Byte des Sprungziels       *
        mov     akku,r0         ; nach Akku retten                     *
        adiw    ZL,1            ; Zeiger auf High-Byte                 *
        lpm                     ; R0 <- High-Byte des Sprungziel       *
; Adresse des Sprungziels nach Z und indirekt springen                 *
        mov     ZL,akku         ; ZL <- Low-Byte                       *
        mov     ZH,r0           ; ZH <- High-Byte                      *
        ijmp                    ; springe indirekt: Zieadresse in Z    *
; hier liegen die vier Zweige der Fallunterscheidung                   *
fall0:  ldi     akku,'0'        ; ASCII-Zeichen 0 = $30                *
        rjmp    aus             ;                                      *
fall1:  ldi     akku,'1'        ; ASCII-Zeichen 1 = $31                *
        rjmp    aus             ;                                      *
fall2:  ldi     akku,'2'        ; ASCII-Zeichen 2 = $32                *
        rjmp    aus             ;                                      *
fall3:  ldi     akku,'3'        ; ASCII-Zeichen 3 = $33                *
aus:    out     PORTB,akku      ; auf Port B ausgeben                  *
        rjmp    loop            ;                                      *
; Sprungtabelle im Konstantenbereich                                   *
stab:   .DW     fall0,fall1,fall2,fall3 ; Adressen der Sprungziele     *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


