

// k6p8.c  ATmega8  Gabellichtschranke Impulszhlung
// Port B: B7-B0: Ausgang Zhler fr fallende Flanken
// Port C: C5-C0: Eingang PC0 = Detector
// Port D: D7-D0: Ausgang Zhler fr steigende Flanken
// Konfiguration: interner Oszillator 1 MHz externes Reset-Signal
#include <avr/io.h>    // Deklarationen
#define fuehl PINC     // Detektorport
#define pin  PC0       // Detektoranschluss
void main(void)       // Hauptfunktion
{
 unsigned char stei, fall;    // Flankenzhler
 DDRB = 0xff;                  // 1111 1111 Port B ist Ausgang
 DDRD = 0xff;                  // 1111 1111 Port D ist Ausgang
 stei = fall = 0;              // Anfangszustand
 PORTB = fall; PORTD = stei;   // Anfangszustand ausgeben
 while(1)                     // Arbeitsschleife 
 {  
   while (  (fuehl & (1 << pin)));                   // warte solange High
   fall++; PORTB = ((fall / 10) << 4) | (fall % 10); // Zhler fallende Flanke
   while ( !(fuehl & (1 << pin)));                   // warte solange Low
   stei++; PORTD = ((stei / 10) << 4) | (stei % 10); // Zhler steigende Flanke
 } // Ende while
} // Ende main
