


// k4p12.c  ATmega8  Test Watchdog Timer
// Port B: Restzeit Einer Zehner
// Port c: Restzeit Hunderter
// PORT D: Taste PD7 beruhigt Wachhund
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal, WDT aus 
#include <avr/io.h>                // Deklarationen
#include <avr/wdt.h>               // vordefinierte Watchdog Funktionen
#define TAKT 1000000UL             // Systemtakt intern ca. 1 MHz
#include "wartex10ms.c"            // wartet Faktor * 10 ms
#include "dual2bcd.c"              // dual -> BCD 
void main(void)                    // Hauptfunktion
{
 unsigned char zaehler, i;         // 8bit Dualzhler
 DDRB = 0xff;                      // Port B ist Ausgang
 DDRC = 0xff;                      // Port C ist Ausgang
 // nach Reset 10 Sekekunden 00 00 anzeigen dann Wachhund scharf machen
 for(i=1; i <= 10; i++) wartex10ms(100); // 10 sek Wartezeit 
 wdt_enable(7);                    // Wachhund scharf machen Zeit ca. 1.9 sek 
 zaehler = 200;                    // Restzeitzhler fr 2000 msek
 while(1)                          // Arbeitsschleife innerhalb von 2 sek PD7 drcken
 {
  if ( !(PIND & (1 << PIND7))) {wdt_reset(); zaehler = 200; }
  PORTB = dual2bcd(zaehler);       // Zehner Einer
  PORTC = dual2bcd(zaehler) >> 8;  // Hunderter
  wartex10ms(1);                   // warte 10 ms
  zaehler--;
 } // Ende while
} // Ende main 


