// inituart.c 
void inituart(void)          // USART bzw. UART initialisieren
{
 unsigned char x;            // Hilfsvariable
 #ifdef UBRRL                // USART-Schnittstelle 
  UBRRL = (TAKT / (8 * BAUD)) - 1;
  UCSRA |= (1 << U2X);
  UCSRB |= (1 << TXEN) | (1 << RXEN);
  UCSRC |= (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0); 
 #else                    // UART-Schnittstelle
  UBRR = (TAKT / (16 * BAUD)) - 1;
  UCR |= (1 << TXEN) | (1 << RXEN);
 #endif 
 x = UDR;                // Empfnger leeren
}