



; test15.asm 16bit signed Negation
; Port B: - 
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
        .INCLUDE "m16def.inc"    ; Deklarationen fr ATmega16
        .INCLUDE "Mkonsole.h"    ; Makros mit Konsolfunktionen
        .EQU    TAKT = 8000000   ; Systemtakt 8 MHz
        .EQU    NPUF = 80        ; Lnge des Eingabepuffers
        .DEF    akkul = r16      ; Arbeitsregister Low
        .DEF    akkuh = r17      ; Arbeitsregister High
        .CSEG                    ; Programm-Flash
         rjmp   start            ; Reset-Einsprung
        .ORG    $2A              ; Interrupteinsprnge bergehen
start:   ldi    akkul,LOW(RAMEND) ; Stapelzeiger laden
         out    SPL,akkul        ;
         ldi    akkul,HIGH(RAMEND);
         out    SPH,akkul        ;
         Minituart 9600          ; USART 9600 Baud bei Frequenz TAKT
         clr    XL               ; X <- 0
         clr    XH               ;
         clr    YL               ; Y <- 0
         clr    YH               ;
; Arbeitsschleife 
loop:
;         com    XL               ; 1er Komplement
;         com    XH               ;
;         subi   XL,-1            ; 2er Komplement +1
;         sbci   XH,-1            ; 
;
         com     XH
         neg     XL
         sbci    XH,-1
; 
         com    YL               ; 1er Komplement
         com    YH               ;
         adiw   YL,1             ; 2er Komplement +1
         cp     XL,YL            ;
         cpc    XH,YH            ; 
         brne   error            ; Abweichung
;
         com    XL               ; Rckkomplementierung
         com    XH               ;
         adiw   XL,2             ; Testwert + 1
         com    YL               ;
         com    YH               ;
         adiw   YL,2             ; Testwert + 1
         Mputkon '*'             ; Kontrollausgabe
         rjmp   loop             ; 
; Fehlermeldung
error:   Mputkon 10              ; neue Zeile
         Mputkon 13              ;
         mov    r16,XH           ; X ausgeben
         rcall  aushex8          ;
         mov    r16,XL           ;
         rcall  aushex8a         ;
         mov    r16,YH           ; Y ausgeben
         rcall  aushex8          ; 
         mov    r16,YL           ;
         rcall  aushex8a         ; 
         Mgetch r16              ; warte auf Taste
         rjmp   loop             ;
; interne Unterprogramme fr Gert und Betriebsart
ausz:    Mputch r16              ; direkte Ausgabe nach USART
         ret                     ; 
einz:    ld     r16,Y+           ; gepufferte Eingabe von USART aus (Y)
         ret                     ; 
; externe Unterprogramme String und Umwandlung
         .INCLUDE "gets.asm"     ; Zeile von USART nach SRAM Adresse in Y
         .INCLUDE "puts.asm"     ; Text aus Flash ausgeben
         .INCLUDE "unsigned16.h"   ; 16bit Umwandlungsprogramme vorzeichenbehaftet ganz
;
; Ausgabetext
prompt:  .DB     10,13,"Eingabe -> ",0
; SRAM-Bereich 
         .DSEG                   ; Datenbereich
puffer:  .BYTE   NPUF            ; Eingabepuffer fr gets
         .EXIT                   ; Ende des Quelltextes


