

; test12.asm  Aufruf von Unterprogrammen
; Port B: Ausgabe LED Dualzhler 250 ms verzgert
; Port D: Eingabe -
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    TAKT = 8000000  ; Takt 8 MHz Symbol fr Unterprogramme
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    zaehl = r17     ; laufender Zhler
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ; 
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        clr     zaehl           ; Zhler lschen
        out     PORTB,zaehl      ; Ausgabe auf Port B
; Arbeitsschleife Abbruch nur mit Reset
loop:   
; Hauptprogramm ruft Unterprogramm ohne Parameter
        ldi     akku,250        ; Zhler fr Schleifendurchlufe
loop1:  rcall   warte1ms        ; wartet 1 ms * 250 = 250 ms
        dec     akku            ; Zhler - 1
        brne    loop1           ; bis 250 Durchlufe = 250 ms
        inc     zaehl           ; 
        out     PORTB,zaehl     ;
; Hauptprogramm bergibt Parameter in einem Register
        ldi     akku,25         ; R16 <- Faktor 
        rcall   wartex10ms      ; 25 * 10 ms = 250 ms warten
        inc     zaehl           ; 
        out     PORTB,zaehl     ;
; Hauptprogramm bergibt Parameter auf dem Stapel
        ldi     akku,250        ; R16 <- 250 ms
        push    akku            ; nach Stapel 
        rcall   wstapel         ; warten
        pop     akku            ; Stapel wiederherstellen
        inc     zaehl           ; 
        out     PORTB,zaehl     ; 
; Hauptprogramm bergibt Parameter in globaler Speicherstelle
        ldi     akku,250        ; R16 <- 250 ms
        sts     faktor,akku     ; nach SRAM 
        rcall   wsram           ; warten
        inc     zaehl           ; 
        out     PORTB,zaehl     ; 
; Hauptprogramm bergibt Adresse des Parameters in Z
        ldi     akku,250        ; R16 <- 250 ms
        ldi     ZL,LOW(faktor)  ; Z <- Adresse des Parameters
        ldi     ZH,HIGH(faktor) ;        
        st      Z,akku          ; nach SRAM 
        rcall   windex          ; warten
        inc     zaehl           ; 
        out     PORTB,zaehl     ; 
        rjmp    loop            ; Arbeitsschleife
;
; interne Unterprogramme
;
; wstapel.asm Stapel = Wartezeit in ms  (0 = 256)
wstapel:  push    r17     ; Register retten
          push    ZL      ;
          push    ZH      ;
          in      ZL,SPL  ; Z <- Zeiger auf Stapel
          in      ZH,SPH  ;
          ldd     r17,Z+5 ; 3 Bytes push  2 Bytes Rckadresse
wstapel1: rcall   warte1ms; wartet 1 ms
          dec     r17     ; Zhler - 1
          brne    wstapel1;
          pop     ZH      ; Register zurck
          pop     ZL      ;
          pop     r17     ; 
          ret             ; Rcksprung
;

; wsram.asm SRAM-Variable = Wartezeit in ms  (0 = 256)
wsram:    push    r17        ; Register retten
          lds     r17,faktor ; R17 <- Faktor aus SRAM
wsram1:   rcall   warte1ms   ; wartet 1 ms
          dec     r17        ; Zhler - 1
          brne    wsram1     ; 
          pop     r17        ; 
          ret                ; Rcksprung
;
; windex.asm Z = SRAM-Adresse der Wartezeit in ms  (0 = 256)
windex:   push    r17       ; Register retten         
          ld      r17,Z     ; R17 <- Faktor indirekt adressiert
windex1:  rcall   warte1ms  ; wartet 1 ms
          dec     r17       ; Zhler - 1
          brne    windex1   ;
          pop     r17       ; 
          ret               ; Rcksprung
;
; externe Unterprogramme werden hier eingefgt
        .INCLUDE "warte1ms.asm" ; wartet 1ms bentigt Symbol TAKT
        .INCLUDE "wartex10ms.asm" ; Faktor in Register R16
;
; SRAM mit Parameter 
        .DSEG                   ; Datensegment
faktor: .BYTE   1               ; 1 Byte fr Parameter 
        .EXIT                   ; Ende des Quelltextes
